$(document).ready(function(){
	
	var elements = [
		{name:'yellow',number:6,dir:'files/img/yellow.jpg'},
		{name:'blue',number:4,dir:'files/img/blue.jpg'},
	];
	
	function showQuestion(){
		$("#cover").fadeIn("slow");
			$("#question").fadeIn("slow",function(){
				$("#question").fadeOut("slow");
				$("#cover").fadeOut("slow");
			});
	}
	
	function showSmile(){
		$('#smile').css({'display':'block'});
	}
	
	function hideSmile(){
		$('#smile').css({'display':'none'});
	}
	
	function calculate(a){
		return new Function('return ' + a)();
	}
	
	function checkEnd(){
		hideSmile();
		var accepted = elements.length;
		var badScore = 0;
		var toCalculate = '';
		for(var i = 0; i < elements.length; i++){
			var inputNumber = $('.mathField:eq('+i+')').data('number');
			var inputVal = parseInt($('.mathField:eq('+i+')').find(':text').val());
			if(inputNumber != inputVal){
				badScore++;
			}
			if(i == 0){
				toCalculate = toCalculate + inputVal + '+';
			}
			else{
				toCalculate = toCalculate + inputVal;
			}
		}
		
		if(badScore == 0){
			if(calculate(toCalculate) == parseInt($('.mathField:eq(2)').find(':text').val())){
				showSmile();
			}
			else{
				showQuestion();
			}
		}
		else{
			showQuestion();
		}
	}
	
	function loadMathField(){
		$('<div id="mathField"></div>').appendTo('#page');
		var i = 0;
		for(i; i < elements.length; i++){
			$('<div class="mathField"></div>').data({'number':elements[i]['number']}).appendTo('#mathField');
			$('<div class="title"><div class="titleContent"><img src="'+elements[i]['dir']+'"></div></div>').appendTo('.mathField:eq('+i+')');
			$('<input type="text" />').keypress(function(e){
				if(e.value === '0'){
					return false;
				}
				var key = (e.which) ? e.which : event.keyCode;
				if(key == 13){
					return true;
				}
				if(key > 31 && (key < 48 || key > 57)){
					return false;
				}
				if($(this).val() === '0'){
					return false;
				}
				if($(this).val().length > 0){
					return false;
				}
				return true;
			}).appendTo('.mathField:eq('+i+')');
			if(i == 0){
				$('<div class="mathChar"><div class="mathCharContent">+</div></div>').appendTo('#mathField');
			}
			else{
				if(i == 1){
					$('<div class="mathChar"><div class="mathCharContent">=</div></div>').appendTo('#mathField');
				}
			}
		}
		$('<div class="mathField"></div>').appendTo('#mathField');
		$('<input type="button" value="Sprawdź" />').click(function(){
			checkEnd();
		}).appendTo('.mathField:eq('+i+')');
		$('<input type="text" />').keypress(function(e){
			if(e.value === '0'){
				return false;
			}
			var key = (e.which) ? e.which : event.keyCode;
			if(key == 13){
				return true;
			}
			if(key > 31 && (key < 48 || key > 57)){
				return false;
			}
			if($(this).val() === '0'){
				return false;
			}
			if($(this).val().length > 1){
				return false;
			}
			return true;
		}).appendTo('.mathField:eq('+i+')');
	}
	
	function loadMessages(){
		$('<div id="question"></div>').appendTo('#page');
		$('<div id="cover"></div>').appendTo('#page');
		$('<div id="smile"></div>').html(':)').appendTo('#mainImg');
	}
	
	function loadMainImage(){
		$('<div class="pseudo"></div>').appendTo('#page');
		$('<div id="mainImg"></div>').appendTo('#page');
		$('<div class="pseudo"></div>').appendTo('#page');
	}
	
	function loadReset(){
		$('<div id="reset"><img src="files/img/reset.png" /></div>').appendTo('#page');
	}
	
	function init(){
		elements.sort(function(){return 0.5-Math.random()});
		$('#page').empty();
		loadMainImage();
		loadMathField();
		loadReset();
		loadMessages();
		$('#reset').click(function(){
			$(init);
		});
	}
	
	$(init);
	
});