var app = {
    configuration: {
        game: {
            hours: [
                {
                    id: 1,
                    text: "7:00",
                    img: 'img/0.jpg'
                },
                {
                    id: 2,
                    text: "7:15",
                    img: 'img/1.jpg'
                },
                {
                    id: 3,
                    text: "7:30",
                    img: 'img/2.jpg'
                },
                {
                    id: 4,
                    text: "8:00",
                    img: 'img/3.jpg'
                },

{
                    id: 5,
                    text: "10:00",
                    img: 'img/5.png'
                },
				
				{
                    id: 6,
                    text: "12:00",
                    img: 'img/6.png'
                },

{
                    id: 7,
                    text: "13:00",
                    img: 'img/7.png'
                },

{
                    id: 8,
                    text: "15:00",
                    img: 'img/8.png'
                },



{
                    id: 9,
                    text: "16:00",
                    img: 'img/00.png'
                },
				
				{
                    id: 10,
                    text: "17:00",
                    img: 'img/00.png'
                },
				
				{
                    id: 11,
                    text: "19:00",
                    img: 'img/00.png'
                },

{
                    id: 12,
                    text: "19:30",
                    img: 'img/00.png'
                },
				
				{
                    id: 13,
                    text: "20:00",
                    img: 'img/00.png'
                }
            ]
        }
    },
    init: function () {
        $('div#success, #wrongAnswer').hide();
        $.each(this.configuration.game.hours, function (index, item) {
            $('#activities').append('<img draggable="true" data-id=' + item.id + ' src=' + item.img + ' class="img-responsive draggable">');
            $('#activitiesGroup').append('<div class="activity" data-id=' + item.id + '><h3>' + item.text + '</h3></div>');
        });

        //Shuffle coins
        var ul = document.querySelector('div#activities');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }


        $("#activities").append('<div class="clearfix" ></div>');
    },
    checkGame: function () {
        var _valid = true;

        if ($('div#activities img').length > 0) {
            _valid = false;
        }

        $("div.activities").each(function (index, item) {
            $('img', item).each(function (_index, _item) {
                if ($(_item).data('id') !== $(item).data('id')) {
                    _valid = false;
                }
            });
        });

        if (_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }

        return _valid;
    }
};

$(document).ready(function () {
    app.init();

    $('img').draggable({
        revert: 'invalid'
    });
    $('.activity, #activities').droppable({
        accept: '.draggable',
        drop: function (evt, ui) {

            if ($('img', this).length < 1 && $(this).hasClass('activity')) {
                $(this).append($(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }));
            } else if ($(this).attr('id') === 'activities') {
                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }).insertBefore($('.clearfix', this));
            } else {
                $(ui.draggable).draggable({
                    revert: true
                });
            }

            $(this).removeClass('activeDrop');
            app.checkGame();
        },
        over: function (event, ui) {
            $(this).addClass('activeDrop');
        },
        out: function (event, ui) {
            $(this).removeClass('activeDrop');
        }
    });

    $(document).on('click', 'a#check, a#check img', function () {
        if (app.checkGame() === false) {
            $('#wrongAnswer').show();
        }
        return false;
    });

    $(document).on('click', '#wrongAnswer', function () {
        $(this).hide();
    });

    $(document).on('click', '#reload', function () {
        location.reload();
    });
});