$(document).ready(function(){
	
	//global variables
	var result;
	var val = $("select").val();
	
	var scorePlus = 0;
	var scoreMinus = 0;
	
	//timer
	var k0 = 0;
	var k1 = 0;
	
	//
	var lastStyle = '';
	
	//interact
	var interact = [
		{a:0,b:0},{a:1,b:1},{a:2,b:2},{a:3,b:3},{a:4,b:4},
		{a:9,b:5},
		{a:14,b:6},{a:13,b:7},{a:12,b:8},{a:11,b:9},{a:10,b:10},
		{a:15,b:11},
		{a:20,b:12},{a:21,b:13},{a:22,b:14},{a:23,b:15},{a:24,b:16},
		{a:29,b:17}
	];
	
	//blank
	var blank = [
		{a:5,b:''},{a:6,b:''},{a:7,b:''},{a:8,b:''},{a:16,b:''},{a:17,b:''},{a:18,b:''},{a:19,b:''},
		{a:25,b:'border: 1px solid black;border-top-left-radius: 25px;border-top-right-radius: 25px;border-bottom-right-radius: 25px;border-bottom-left-radius: 5px;background: rgb(0, 92, 0);'},
		{a:26,b:'border: 1px solid black;border-top-left-radius: 25px;border-top-right-radius: 25px;border-bottom-right-radius: 25px;border-bottom-left-radius: 5px;background: rgb(172, 0, 0);'},
		{a:27,b:'border: 1px solid black;border-top-left-radius: 25px;border-top-right-radius: 25px;border-bottom-right-radius: 25px;border-bottom-left-radius: 5px;background: rgb(148, 66, 28);'},
		{a:28,b:''}
	];
		
	//field -> option
	var radius = [
		{a:0,b:'border-top-left-radius',c:'5px'},
		{a:4,b:'border-top-right-radius',c:'5px'},
		{a:25,b:'border-bottom-left-radius',c:'5px'},
		{a:29,b:'border-bottom-right-radius',c:'5px'}
	];
	
	$("select").change(function() {
		val = $(this).val();
		randomCube(val);
		randomPawn();
	});
	
	$('#button').click(function(){
		randomCube(val);
		randomPawn();
	});
	
	function functionDrop(event, ui){
		
		if($(this).data('id') == result){
			$('#message').css('display','block');
			$('#message').fadeOut(600);
			randomCube(val);
			randomPawn();
			scorePlus++;
		}
		else{
			scoreMinus++;
			$('#face').html(':(');
		}
		
		$('#scorePlus').html(scorePlus);
		$('#scoreMinus').html(scoreMinus);
		
	}
	
	function createBoard(){
		
		$('.field').data('touch',1);
		
		for(var i = 0; i < blank.length; i++){
			
			if(blank[i]['b'] !== ''){
			
				var csstxt = blank[i]['b'];
				$('.field').eq(blank[i]['a']).css('cssText', csstxt).data('touch',0);
				
			}
			else{
				$('.field').eq(blank[i]['a']).css({
					'background':'rgba(0, 0, 0, 0)',
					'height':'61px',
					'width':'100px',
					'float':'left',
					'box-sizing':'border-box',
					'border':'solid 1px transparent',
					'box-shadow':'inset 0px 0px 25px 1px transparent',
					'border-radius':'0px'
				}).data('touch',0);
			}
		}
		
		for(var i = 0; i < radius.length; i++){
			$('.field').eq(radius[i]['a']).css(radius[i]['b'],radius[i]['c']);
		}
		
		for(var  i = 0; i < interact.length; i++){
			$('.field').eq(interact[i]['a']).data('id',interact[i]['b']).droppable({
				accept: '#container-content .pawn',
				hoverClass: 'hovered',
				drop: functionDrop
			}).append('<div class="numberOfField">'+(i+1)+'</div>');
		}
		
		$('<div id=scorePlus class=textBottom>0</div>').appendTo($('.field').eq(25));
		$('<div id=scoreMinus class=textBottom>0</div>').appendTo($('.field').eq(26));
		
	}
	
	function randomPawn(){
		
		$('.pawn').remove();
		
		var k = blank.length-4;
		var math = Math.floor(Math.random()*k);
		var pos = $('.field').eq(blank[math]['a']).position();
		
		$('<div class=pawn></div>').appendTo('#container-content').draggable({
			containment: '#container-content',
			revert: false
		}).css({'top':pos['top']+6,'left':pos['left']+25}).append("<div id=face>:)</div>");
		
	}
	
	function randomCube(val){
		
		var a = 0;
		$('#button').html('');
		
		for(var i = 0; i < val; i++ ){
			var j = Math.floor((Math.random()*6)+1);
			$('<img src=files/img/'+j+'.png />').appendTo('#button');
			a = a + j;
		}
		
		result = a-1;
		
	}
	
	function timer(){
	
		$('.field').eq(27).html('<div id=timer class=textBottom>00:00</div>');
		
		setInterval(function(){
			
			var q1 = '';
			var q2 = '';
			
			if(k1 >= 99 && k0 > 59){
				k0 = 0;
				k1 = 0;
			}
			
			if(k0 > 59){
				k0 = 0;
				k1++;
			}
			
			if(k0 < 10){
				q1 = '0';
			}
			
			if(k1 <= 9){
				q2 = '0';
			}
			
			$('#timer').html(q2+k1+':'+q1+k0);
			
			k0++;
			
		}, 1000);
	}
	
	function init(){
		
		randomCube(val);
		createBoard();
		randomPawn();
		
		timer();
		
	}
	
	init();
	
});