$(document).ready(function(){
	
	var elements = [
		{destination:1,dir:'files/img/deskorolka.png'},
		{destination:0,dir:'files/img/kalosze.png'},
		{destination:0,dir:'files/img/parasol.png'},
		{destination:0,dir:'files/img/plaszczyk.png'},
		{destination:0,dir:'files/img/sztormiak.png'},
		{destination:1,dir:'files/img/trampki.png'},
		{destination:1,dir:'files/img/lyzwy.png'},
	];
	
	var fields = [
		{name:0,dir:['files/img/deszcz.png'],imgCss:'60px',titleCss:'rgb(0, 51, 90)',contentCss:'rgb(0, 68, 121)'},
		{name:1,dir:['files/img/slonce.png'],imgCss:'60px',titleCss:'rgb(0, 102, 255)',contentCss:'rgb(155, 195, 255)'},
	];
	
	function loadFields(){
		for(var i = 0; i < fields.length; i++){
			$('<div class="recyclebin"></div>').appendTo('#page');
			
			$('<div class="title"><div class="titleContent"></div></div>').css({'background':fields[i]['titleCss']}).appendTo('.recyclebin:eq('+i+')');
			
			for(var j = 0; j < fields[i]['dir'].length; j++){
				var img = '<img src="'+fields[i]['dir'][j]+'"/>';
				$(img).css({'height':fields[i]['imgCss']}).appendTo('.titleContent:eq('+i+')');
			}
			
			$('<div class="droppable"></div>').css({'background':fields[i]['contentCss']}).data({'name':fields[i]['name']}).appendTo('.recyclebin:eq('+i+')').droppable({
				accept: '#draggable div',
				drop: drop0
			});
		}
	}
	
	function loadWords(){
		var width = 0;
		var top = 5;
		$('<div id="draggable"></div>').appendTo('#page');
		for(var i = 0; i < elements.length; i++){
			$('<div class="element"><img src="'+elements[i]['dir']+'"/></div>').data({'parent':-1,'destination':elements[i]['destination']}).appendTo('#draggable').draggable({
				containment: '#page',
				stack: '#draggable div',
				revert: false,
			}).css({'top':top,'left':(10+(i*2))});
		}
		$('<div id="droppableReset"></div>').appendTo('#page').droppable({
			accept: '#draggable div',
			drop: drop1
		});
		$('<div id="smile"></div>').html(':)').appendTo('#droppableReset');
	}
	
	function drop1(event,ui){
		ui.draggable.data('parent',-1);
		$('#smile').css({'display':'none'});
		checkEnd();
	}
	
	function drop0(event,ui){
		var thisName = $(this).data('name');
		ui.draggable.data('parent',thisName);
		$('#smile').css({'display':'none'});
		checkEnd();
	}
	
	function checkEnd(){
		var score = 0;
		for(var i = 0; i < elements.length; i++){
			if($('.element:eq('+i+')').data('parent') == $('.element:eq('+i+')').data('destination')){
				score++;
			}
		}
		if(score == elements.length){
			showChoose();
		}
		else{
			hideChoose();
		}
	}
	
	function showChoose(){
		$('#chooses').css({'display':'block'});
		$('#draggable').css({'position':'static','z-index':'0'});
		$('.choose').click(function(){
			if($(this).data('number') == 1){
				$('#smile').css({'display':'block'});
				$('#chooses').css({'display':'none'});
			}
			else{
				$('#smile').css({'display':'none'});
				$("#cover").fadeIn("slow");
				$("#question").fadeIn("slow",function(){
					$("#question").fadeOut("slow");
					$("#cover").fadeOut("slow");
				});
			}
		});
	}
	
	function hideChoose(){
		$('#draggable').css({'position':'relative','z-index':'20'});
		$('#chooses').css({'display':'none'});
		$('#smile').css({'display':'none'});
	}
	
	function loadChooses(){
		var a = [
			{number:0,charakter:'<'},
			{number:1,charakter:'>'},
		];
		$('<div id="chooses"></div>').appendTo('#droppableReset');
		for(var i = 0; i < a.length; i++){
			$('<div class="choose">'+a[i]['charakter']+'</div>').data({'number':a[i]['number']}).appendTo('#chooses');
		}
	}
	
	function loadQuestion(){
		$('<div id="question"></div>').appendTo('body');
		$('<div id="cover"></div>').appendTo('body');
	}
	
	function init(){
		elements.sort(function(){return 0.5 - Math.random()});
		loadFields();
		loadWords();
		$('<div id="reset"><img src="files/img/reset.png" style="width: 28px;"></div>').appendTo('.title:eq(1)').click(function(){
			reset();
		});
		loadChooses();
		loadQuestion();
	}
	
	$(init);
	
	function reset(){
		$('#page').empty();
		$(init);
	}
	
});