var app = {
    configuration: {
        game: {
            equasions: [
                {
                    id: 1,
                    text: '20 - 11 =',
                    result: 9
                },
                {
                    id: 2,
                    text: '8 + 1 =',
                    result: 9
                },
                {
                    id: 3,
                    text: '13-6 =',
                    result: 7
                }
            ]
        }
    },
    init: function () {
        $('div#success, #wrongAnswer').hide();
        $.each(this.configuration.game.equasions, function (index, item) {
            var _item = '<div class="equasion bg-info"><p>' + item.text + ' <input type="text" data-equasion-id=' + item.id + ' size=2 /></p></div>';
            $(_item).insertBefore('#check');
        });
    }
};

$(document).ready(function () {
    app.init();

    $(document).on('keypress', 'input', function (evt) {
        var key = evt.which || e.keyCode;
        if (key < 48 || key > 57) {
            return false;
        }
    });


    $(document).on('click', 'a#check', function () {
        var _valid = true;

        $('input').each(function (index, item) {
            if (parseInt($(this).val()) !== app.configuration.game.equasions[index].result) {
                _valid = false;
            }
        });

        if (_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        } else {
            $('#wrongAnswer').show();
        }

        return false;
    });

    $(document).on('click', '#wrongAnswer', function () {
        $(this).hide();
    });

    $(document).on('click', '#reload', function () {
        location.reload();
    });
});