var app = {
    configuration: {
        game: {
            laws: [
                {
                    id: 1,
                    img: 'img/rodzina.jpg',
                    sentence: "Mam prawo do wychowania w rodzinie"
                },
                {
                    id: 2,
                    img: 'img/nauka.jpg',
                    sentence: "Mam prawo do nauki"
                },
                {
                    id: 3,
                    img: 'img/zdrowie.jpg',
                    sentence: "Mam prawo do ochrony zdrowia"
                },
                {
                    id: 4,
                    img: 'img/przemoc.jpg',
                    sentence: "Mam prawo do wolności od przemocy fizycznej i psychicznej"
                },
                {
                    id: 5,
                    img: 'img/tozsamosc.jpg',
                    sentence: "Mam prawo do tożsamości - do imienia i nazwiska"
                },
                {
                    id: 6,
                    img: 'img/zabawa.jpg',
                    sentence: "Mam prawo do zabawy i odpoczynku"
                },
            ]
        }
    },
    init: function () {
        $('#success, #wrongAnswer').hide();
        $.each(this.configuration.game.laws, function (index, item) {
            $('#laws').append('<div class="col-lg-6 col-md-6 col-xs-12 law" data-law-id=' + item.id + '><img src="' + item.img + '"><div class="sentence"><ul></ul></div></div>');
            $('ul#sentences').append('<li draggable="true" data-sentence-id=' + item.id + ' class="draggable"><p>' + item.sentence + '</p></li>');
        });

        //Shuffle sentences
        var ul = document.querySelector('ul#sentences');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }

        ul = document.querySelector('#laws');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }

        var _elmnts = $('div.law');
        for (var i = 0; i < _elmnts.length; i += 2) {
            _elmnts.filter(':eq(' + i + '),:lt(' + (i + 2) + '):gt(' + i + ')').wrapAll('<div class="row"/>');
        }
    },
    checkGame: function () {
        var _valid = true;

        if ($('ul#sentences li').length > 0) {
            return false;
        }

        $('div.law').each(function (index, item) {
            if ($(this).data('law-id') !== $('ul li', item).data('sentence-id')) {
                _valid = false;
            }
        });

        if (_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }

        return false;
    }
};

$(document).ready(function () {
    app.init();

    $('li').draggable({
        revert: 'invalid'
    });
    $('ul').droppable({
        accept: '.draggable',
        drop: function (evt, ui) {
            if ($('li', this).length === 0 || $(this).attr('id') === 'sentences') {
                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }).appendTo($(this));
            } else {
                $(ui.draggable).draggable({
                    revert: true
                });
            }
            $(this).removeClass('activeDrop');

            app.checkGame();
        },
        over: function (event, ui) {
            $(this).addClass('activeDrop');
        },
        out: function (event, ui) {
            $(this).removeClass('activeDrop');
        }
    });

    $(document).on('click', 'li', function () {
        if (!$(this).hasClass('selected') && $('.selected').length === 0) {
            $(this).addClass('selected');
        } else {
            if ($(this).parent().attr('id') !== 'sentences') {
                $('#sentences').append($(this));
            }
            $(this).removeClass('selected');
        }
        return false;
    });

    $(document).on('click', 'div.sentence', function () {
        if ($('.selected').length === 1) {
            if ($(this).hasClass('sentence')) {
                $('ul', this).append($('.selected'));
            } else {
                $(this).append($('.selected'));
            }

            $('.selected').removeClass('selected');
        }
    });

    $(document).on('click', 'a#check, a#check img', function () {
        if (app.checkGame() === false) {
            $('#wrongAnswer').show();
        }
        return false;
    });

    $(document).on('click', '#wrongAnswer', function () {
        $(this).hide();
    });

    $(document).on('click', '#reload', function () {
        location.reload();
    });
});

$(window).on('resize load', function (e) {
    $('img').each(function (index, item) {
        var _padding = 256 - $(item).height();
        if (_padding > 0) {
            if (_padding % 2 === 0) {
                $(item).css('padding-top', _padding / 2 + "px").css('padding-bottom', _padding / 2 + "px");
            } else {
                $(item).css('padding-top', parseInt(_padding / 2) + "px").css('padding-bottom', (_padding - 1) / 2 + "px");
            }
        }
    });
});