var stage = 1;

function nextStage() {
    stage++;
    if (stage <= 6) {
        $('.stage').hide();
        $('#stage-' + stage).show();
        startStage();
    } else {
        setTimeout(function () {
            $('.end-popup').show();
        }, 500);
    }
}

function animate($box) {
    var text = $box.find('p');
    var note = $box.find('.note');
    var positions = [];
    var widths = [];
    var add_width = true;
    var elements = [];

    if(text.hasClass('letters')){
        add_width = false;
    }

    text.find('span').each(function (i, v) {
        positions.push($(this).position().left - 20);
        widths.push($(this).width());
        elements.push($(this));
    });

    var prev_position = note.position().left;
    var animation_counter = 0;
    for (var i = 0; i < positions.length; i++) {
        setTimeout(function () {

            if(add_width){
                var position = positions[animation_counter] + (widths[animation_counter] / 3);
            }else{
                var position = positions[animation_counter];
            }

            var animation_width = position - prev_position;
            prev_position = position;

            $(note).animate({
                "left": "+=" + animation_width + "px"
            }, 500, "linear");
            elements[animation_counter].addClass("current").delay(500).queue(function(next){
                $(this).removeClass("current");
            });

            animation_counter++;
        }, 1000 * i);
    }
}

function startStage() {
    animate($('#stage-' + stage).find('.question-box').first());
    $('#stage-' + stage).find('input').first().focus();
}


$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });

    $('input').on('keyup', function () {
        if($(this).data('element-number') == $(this).val()){
            $(this).addClass('approved').removeClass('notapproved');
            setTimeout(function () {
                nextStage();
            }, 500);
        }else{
            $(this).addClass('notapproved').removeClass('approved');
        }
    }).val('');

    $('.letters').each(function () {
        var text = $(this).html();
        var new_text = '';
        for (var i = 0; i < text.length; i++) {
            if (text[i] != ' ' && text[i] != '.') {
                new_text += '<span>' + text[i] + '</span>';
            }else{
                new_text += text[i];
            }
        }
        $(this).html(new_text);
    });

    $('.stage').hide();
    $('#stage-' + 1).show();

    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        setTimeout(function () {
            startStage();
        }, 1000);

        return false;
    });

});

