var class_draggable = '.item';
var class_droppable = '#cart';
var total_money = 20;

function testOrder() {
    if($('#shopping-list li.checkmark').length == 4){
        setTimeout(function () {
            $('.end-popup').show();
        }, 500);
    }else{
        var price_needed = 0;
        $('#shopping-list li').each(function () {
           if(!$(this).hasClass('checkmark')){
               price_needed += $(this).data('min-price');
           }
        });

        if(price_needed > total_money){
            setTimeout(function () {
                $('.end-popup-error').show();
            }, 500);
        }
    }
}

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }
            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            if (total_money - parseInt(ui.draggable.data('price')) < 0) {
                ui.draggable.data('dropped', false);
                ui.draggable.addClass('notapproved');
                setTimeout(function () {
                    ui.draggable.removeClass('notapproved');
                }, 1000);
                $('#alert').show().delay(1000).fadeOut();
                return false;
            }

            ui.draggable.data('dropped', true);
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');
            
            ui.draggable.removeClass('notapproved').addClass('approved');

            $('#equation').css('visibility', 'visible');
            $('.money').html(total_money);
            $('.item-price').html(ui.draggable.data('price'));
            $('.result').html(total_money - parseInt(ui.draggable.data('price')));
            total_money -= parseInt(ui.draggable.data('price'));
            $('li#' + ui.draggable.data('category')).addClass('checkmark');

            testOrder();
        }
    });

    $('#draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            ui.draggable.removeClass('notapproved');
        }
    });


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });

});

