var app = 
{
    configuration: {
        game: {
            activities: [
                {id: 1, img: 'img/jezioro.jpg', sentence: "Krysia spędzi  wakacje nad jeziorem."},
                {id: 2, img: 'img/gory.jpg', sentence: "Olaf spędzi tydzień w górach."},
                {id: 3, img: 'img/las.jpg'},
                {id: 4, img: 'img/miasto.jpg', sentence: "Kasia i Antoś odwiedzą ciocię w Warszawie."},
                {id: 5, img: 'img/morze.jpg', sentence: "Ania pojedzie nad morze."},
                {id: 6, img: 'img/wies.jpg', sentence: "Krzyś odwiedzi babcię na wsi"},
            ]
        }
    },
    init: function() {
        $('#success').hide();
        $.each(this.configuration.game.activities, function(index, item) {
            $('#activities').append('<div class="col-lg-6 col-md-6 col-xs-12 activity" data-activity-id=' + item.id + '><img src="' + item.img + '" class="img-responsive"><div class="sentence"><ul></ul></div></div>');
            if(item.hasOwnProperty('sentence')) {
                $('ul#sentences').append('<li draggable="true" data-sentence-id=' + item.id + ' class="draggable"><p>' + item.sentence + '</p></li>');
            }
        });
                
        //Shuffle sentences
        var ul = document.querySelector('ul#sentences');
        for (var i = ul.children.length; i >= 0; i--) {
            ul.appendChild(ul.children[Math.random() * i | 0]);
        }
        
        var _elmnts = $('div.activity');
        for(var i=0; i < _elmnts.length; i+=2) {
            _elmnts.filter(':eq(' + i + '),:lt(' + (i+2) + '):gt('+i+')').wrapAll('<div class="row"/>');
        }
    },
    checkGame: function() {
        var _valid = true;
        
        if($('ul#sentences li').length > 0) {
            return false;
        }
                
        $('div.law').each(function(index, item) {
            if($(this).data('activity-id') !== $('ul li', item).data('sentence-id')) {
                _valid = false;
            }
        });
       
        if(_valid === true) {
            $('.row').hide();
            $('body').css('background-image', 'url(img/bg.jpg)').css('background-size', '100%');
            $('#success').slideToggle();
        }
        
        return false;
    }
};

$(document).ready(function() {
    app.init();
                
    $('li').draggable({ revert: 'invalid'});
    $('ul').droppable({
        accept: '.draggable',
        drop: function(evt, ui) {
            if($('li', this).length === 0 || $(this).attr('id') === 'sentences') {
                $(ui.draggable).detach().css({top: 0,left: 0}).appendTo($(this));
            } else {
                $(ui.draggable).draggable({revert: true});
            }
            $(this).removeClass('activeDrop');
            
            app.checkGame();
        },
        over: function(event, ui) {
            $(this).addClass('activeDrop');
        },
        out: function(event, ui) {
            $(this).removeClass('activeDrop');
        }
    });
    
    $(document).on('click', 'li', function() {
        if(!$(this).hasClass('selected') && $('.selected').length === 0) {
            $(this).addClass('selected');
        } else {
            if($(this).parent().attr('id') !== 'sentences') {
                $('#sentences').append($(this));
            }
            $(this).removeClass('selected');
        }
        return false;
    });
    
    $(document).on('click', 'div.sentence', function() {
        if($('.selected').length === 1) {
            if($(this).hasClass('sentence')) {
                $('ul', this).append($('.selected'));
            } else {
                $(this).append($('.selected'));
            }
            
            $('.selected').removeClass('selected');
        }
    });
    
    $(document).on('click', 'a#check', function() {
        app.checkGame();
    })
});


$(window).on('resize load', function(e) {
    $('img').each(function(index, item) {
        var _padding = 256 - $(item).height();
        if(_padding > 0) {
            if(_padding%2 === 0) {
                $(item).css('padding-top', _padding/2 + "px").css('padding-bottom', _padding/2+"px");
            } else {
                $(item).css('padding-top', parseInt(_padding/2) + "px").css('padding-bottom', (_padding-1)/2+"px");
            }
        }
    });
});