var class_draggable = '.caption';
var class_droppable = '.image-caption';

var stage = 1;
var wrongAnswered = false;
var correctAnswer = 0;

function testOrder() {
    var allok = true;
    $(class_droppable).each(function () {
        if ($(this).find(class_draggable).length == 0 || $(this).data('element-id') != $(this).find(class_draggable).data('element-id')) {
            allok = false;
        }
    });

    if (allok) {
        if (correctAnswer > 0) {
            setTimeout(function () {
                $('.end-popup.good').show().find('span').html(correctAnswer);
            }, 2000);
        } else {
            setTimeout(function () {
                $('.end-popup.wrong').show().find('span').html(correctAnswer);
            }, 2000);
        }
    } else {
        setTimeout(function () {
            $('#stage-' + stage).hide();
            stage++;
            $('#stage-' + stage).show();
            wrongAnswered = false;
        }, 1000);

    }
}


$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        containment: "body",
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {

            if ($(this).data('element-id') !== ui.draggable.data('element-id')) {
                ui.draggable.data('dropped', false);
                ui.draggable.addClass('notapproved');
                setTimeout(function () {
                    ui.draggable.css('left', 0).animate({
                            left: ($(document).width() - 150) + "px"
                        }
                    )
                }, 300);
                wrongAnswered = true;
                return false;
            }

            ui.draggable.data('dropped', true);


            var prev_element = $(this).children(class_draggable);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            prev_element.each(function () {
                $(this).appendTo('.draggables').removeClass('notapproved');
            });

            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
                if (!wrongAnswered) {
                    correctAnswer++;
                    $('#points').find('span').html(correctAnswer);
                }
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();
        }
    });

    $('.draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();


    $('#start-game').on('click', function () {


        $('#stage-' + stage).show();
        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });

});
