;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            humanWidth: 707,
            humanHeight: 741,
            humanWidthRelative: 0.36
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            $(window).on("resize", function()
            {
                _this.resize();
            });
            $(window).load(function()
            {
                $(this).trigger("resize");
            });

            this.$element.find(".draggable").draggable({
                revert: "invalid",
                helper: "clone",
                appendTo: "#human",
                start: function()
                {
                    $(this).removeClass("answer-correct").removeClass("answer-incorrect");
                }
            });

            this.$element.find(".droppable").droppable({
                accept: ".draggable",
                drop: function(evt, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo(_this.$element.find(".elements")).css({
                            position: "relative",
                            left: "auto",
                            top: "auto"
                        });
                    }

                    if($(this).is(".elements"))
                    {
                        $(ui.draggable).detach().css({
                            top: "auto",
                            left: "auto",
                            position: "relative"
                        }).appendTo($(this));
                    }
                    else
                    {
                        $(ui.draggable).detach().css({
                            top: "-2px",
                            left: "-2px",
                            position: "absolute"
                        }).appendTo($(this));
                    }

                    $(this).removeClass("active-drop");

                    _this.check();
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".element").randomize();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });
        },
        resize: function()
        {
            var humanRatio = this.settings.humanWidth / this.settings.humanHeight,
                windowWidth = $(window).width(),
                windowHeight = $(window).height(),
                humanWidth = windowWidth * this.settings.humanWidthRelative,
                humanHeight = humanWidth / humanRatio;

            this.$element.find("#human").css({
                width: humanWidth + "px",
                height: humanHeight + "px"
            });

            this.$element.find(".left, .right").css({
                height: windowHeight + "px"
            });

            var elementWidth = this.$element.find("#human .parts .part-1").width(),
                elementHeight = this.$element.find("#human .parts .part-1").height();

            this.$element.find(".element").css({
                width: elementWidth + 1 + "px",
                height: elementHeight + "px",
                lineHeight: elementHeight + "px",
                fontSize: elementHeight * 0.7 + "px"
            });
        },
        check: function()
        {
            var isCorrect = true;
            this.$element.find("#human .part .element").each(function()
            {
                var $this = $(this).removeClass("answer-correct").removeClass("answer-incorrect");
                if($.trim($this.text().toLowerCase()) === $this.closest(".part").attr("data-correct-element").toLowerCase())
                {
                    $this.addClass("answer-correct");
                }
                else
                {
                    $this.addClass("answer-incorrect");
                    isCorrect = false;
                }
            });

            if(isCorrect && this.$element.find(".part .element").size() === 9)
            {
                this.$element.find(".popup-result, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);