$(function () {
    var stage = 1;

    $('input').val('').end().prop('disable', false);

    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
    });

    function checkAll(){
        if($('#stage-' + stage).find('.left-box').length == 0 && $('#stage-' + stage).find('.right-box').length == 0){
            $('#stage-' + stage).find('.next').css('visibility', 'visible');
        }
    }

    $('.button-wrapper').find('a').on('click', function(){
        var grandpa = $(this).parent().parent();
        if($(this).hasClass('correct')){
            if(grandpa.hasClass('left-result')){
                $('#stage-'+ stage).find('.left-box').remove();
            }else{
                $('#stage-'+ stage).find('.right-box').remove();
            }
        }else{
            var correct = $(this).siblings('.correct').html();
            grandpa.find('.button-wrapper').remove();
            grandpa.find('input').data('correct', correct).show();
            $('#stage-'+ stage).find('.alert-bubble').show().delay( 1000).fadeOut('slow');
        }

        checkAll();

        return false;
    });

    function nextStage(){
        stage++;
        if(stage == 4) {
            $('.end-popup').show();
        }else{
            $('.stage').hide();
            $('#stage-'+stage).show();
        }

    }

    $('.next').on('click', function(){
        nextStage();
        return false;
    });

    $('body').delegate('input', 'keyup', function(){
        if($(this).val() == $(this).data('correct')){
            $(this).addClass('correct').removeClass('incorrect');
            if($(this).parent().hasClass('left-result')){
                $('#stage-'+ stage).find('.left-box').remove();
            }else{
                $('#stage-'+ stage).find('.right-box').remove();
            }
        }else{
            $(this).addClass('incorrect').removeClass('correct');
        }
        checkAll();
    });

    $('.stage').hide();
    $('#stage-' + stage).show();

    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }
        return false;
    });
});