$(function () {
    var class_draggable = '.mark';
    var class_droppable = '.mark-place';
    var stage = 0;

    var items = {
        '1': ['mniszek', 25, 'mniszek'],
        '2': ['jaskier', 40, 'jaskier'],
        '3': ['niezapominajka', 20, 'niezapominajka'],
        '4': ['szczaw', 45, 'szczaw'],
        '5': ['koniczyna', 30, 'koniczyna'],
        '6': ['stokrotka', 10, 'stokrotka'],
        '7': ['rumianek', 50, 'rumianek'],
        '8': ['chaber łąkowy', 60, 'chaberlakowy']
    };

    var ids = [1, 2, 3, 4, 5, 6, 7, 8];
    ids.sort(function () {
        return 0.5 - Math.random()
    });

    var $stage_content = $('#stage-content').clone();

    function testOrder() {

        if ($('#mark').data('element-id') == $('#mark').find('.mark').data('element-id')) {
            if (stage == 4) {
                $('.end-popup').show();
            } else {
                $('.next').css('visibility', 'visible')
            }
        }

    }

    function nextStage() {
        $('#stage-content').remove();

        var $tmp_stage = $stage_content.clone();
        $('#stage').append($tmp_stage);

        stage++;
        var index = (stage * 2) - 1;
        var item_1 = items[ids[index - 1]];
        var item_2 = items[ids[index]];

        $('#item-1').find('.image-caption').html(item_1[0]);
        $('#item-1').find('.plant-size').html(item_1[1] + 'cm');
        $('#item-1').find('.background').attr('src', 'images/' + item_1[2] + '.png');

        $('#item-2').find('.image-caption').html(item_2[0]);
        $('#item-2').find('.background').attr('src', 'images/' + item_2[2] + '.png');
        $('#item-2').find('.plant-size').html(item_2[1] + 'cm');

        if (item_1[1] > item_2[1]) {
            $('#stage').find('#mark').data('element-id', 'more')
        } else {
            $('#stage').find('#mark').data('element-id', 'less')
        }

        if (item_1[1] == item_2[1]) {
            $('#stage').find('#mark').data('element-id', 'equal')
        }

        addDraggable();
    }

    function addDraggable() {
        $(class_draggable).draggable({
            start: function (event, ui) {
                ui.helper.data('dropped', false);
                if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                    $(this).parent().removeClass('haselement');
                }
                $(this).css('z-index', '10');
            },
            revert: function (dropped) {
                var dropped = dropped && dropped[0].id == "droppable";
                if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                    $(this).parent().addClass('haselement');
                }
                if (!dropped) {
                    $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                    $(this).appendTo($(this).data('originalParent'));
                    $(this).css('z-index', '2');
                }

                return !dropped;
            }
        });

        $(class_droppable).droppable({
            accept: class_draggable,
            activeClass: "ui-state-hover",
            hoverClass: "ui-state-active",
            drop: function (event, ui) {
                ui.draggable.data('dropped', true);


                var prev_element = $(this).children(class_draggable);

                if (prev_element.length > 0 &&
                    prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                    return true;
                }

                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }).appendTo(this);
                $(this).addClass('haselement');


                prev_element.each(function () {
                    $(this).appendTo('.draggables').removeClass('notapproved');
                });

                if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                    ui.draggable.draggable({disabled: true});
                    $(this).droppable('disable');
                    ui.draggable.removeClass('notapproved').addClass('approved');
                } else {
                    ui.draggable.addClass('notapproved');
                }
                testOrder();
            }
        });

        $('.draggables').droppable({
            accept: class_draggable,
            activeClass: "ui-state-hover",
            hoverClass: "ui-state-active",
            drop: function (event, ui) {
                ui.draggable.data('dropped', true);
                ui.draggable.parent().removeClass('haselement');
                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }).appendTo(this);

                ui.draggable.removeClass('notapproved');
            }
        });

        $('.next').on('click', function () {
           nextStage();
        });
    }

    function resize() {
        var $bg = $('img.background');
        if ($bg.height() > $(window).height()) {
            $bg.css('max-height', ($(window).height() - 20) + 'px');
        } else {
            $bg.css('max-height', 'none');
        }
    }


    nextStage();
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });



    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        resize();
        return false;
    });


    $(window).resize(function () {
        resize();
    });
});

