(function (win, doc, $) {
    var View = function (game, opts) {
        this.game = game;
        this.$gameScreen = $(game.gameScreen);
        this.elementsCount = 0;
        this.shellNodeHeight = 50;
        this.playStatus = 1;
        this.screenNum = 1;
        this.loopTimeout;
        this.randomShellsIds = new Array();

        this.createScreen = function () {
            var width = window.innerWidth,
                height = window.innerHeight;

            this.$gameScreen
                .height(height - height * 0.2)
                .hide();

            this.shellNodeHeight = height * 0.10;
        };

        this.showScreen = function () {
            this.$gameScreen.show();

            $('#refresh').show();
        };

        this.clearScreen = function () {
            this.$gameScreen.find('.shell').remove();
        };

        this.createShells = function () {
            var $shellNode = $('<div/>'),
                height = this.shellNodeHeight;

            $shellNode
                .addClass('shell')
                .height(height);

            if (this.screenNum == this.game.configuration.game.randomShellsScreen) {
                $shellNode.addClass('shell-random');
            }

            for (i = 0; i < this.game.configuration.game.shells; i++) {
                var $shellText = $('<p/>');

                $shellText
                    .css('lineHeight', height + 'px')
                    .text('');

                $shellNode
                    .clone()
                    .attr('id', i + 1)
                    .html($shellText)
                    .appendTo(this.$gameScreen);
            }

            if (this.screenNum < this.game.configuration.game.randomShellsScreen) {
                this.fillShell();
            } else {
                this.fillRandomShell();
            }
        };

        this.fillShell = function () {
            _self = this;

            if (this.playStatus == 1) {
                this.loopTimeout = setTimeout(function () {
                    _self.setShellNumber();
                }, this.game.configuration.game.shellTimeOut);
            }
        };

        this.fillRandomShell = function () {
            var randomShellId;

            for (var i = 0; i < this.game.configuration.game.randomShellsCount; i++) {
                randomShellId = Math.floor((Math.random() * this.game.configuration.game.shells) + 1);

                while (this.randomShellsIds.indexOf(randomShellId) > -1) {
                    randomShellId = Math.floor((Math.random() * this.game.configuration.game.shells) + 1);
                }

                this.randomShellsIds.push(randomShellId);
            }

            this.setRandomShellNumber();
        };

        this.setShellNumber = function () {
            this.removeActiveShellStatus();

            var $shellNode = this.$gameScreen.find('.shell:not(.filled)').first(),
                shellNodeId = $shellNode.attr('id');

            $shellNode.find('p')
                .text(shellNodeId);

            $shellNode
                .addClass('filled')
                .addClass('active');

            if (shellNodeId < this.game.configuration.game.shells && this.playStatus == 1) {
                this.fillShell();
            }

            if (shellNodeId == this.game.configuration.game.shells) {
                this.removeActiveShellStatus();
                this.showNextButton();
            }
        };

        this.setRandomShellNumber = function () {
            var filledShells = 0;

            while (filledShells < this.game.configuration.game.randomShellsCount) {
                var $shellNode = this.$gameScreen.find('.shell:not(.filled)').first(),
                    shellNodeId = parseInt($shellNode.attr('id')),
                    inputNode = $('<input/>');

                if (this.randomShellsIds.indexOf(shellNodeId) == -1) {
                    $shellNode.find('p')
                        .text(shellNodeId);

                } else {
                    $shellNode
                        .addClass('active');

                    $shellNode.find('p').remove();
                    $shellNode.append(inputNode);


                    ++filledShells;
                }

                $shellNode
                    .addClass('filled');
            }
            while (this.$gameScreen.find('.shell:not(.filled)').length > 0) {
                $shellNode = this.$gameScreen.find('.shell:not(.filled)').first();
                shellNodeId = parseInt($shellNode.attr('id'));

                $shellNode.find('p')
                    .text(shellNodeId);
                $shellNode
                    .addClass('filled');
            }

            this.showCheckButton();
            //this.delegateEvents();
        };

        this.removeActiveShellStatus = function () {
            this.$gameScreen.find('.active').removeClass('active');
        };

        this.play = function () {
            this.playStatus = 1;

            if (this.screenNum < this.game.configuration.game.randomShellsScreen) {
                this.fillShell();
            } else {
                this.fillRandomShell();
            }
        };

        this.pause = function () {
            this.playStatus = 0;

            clearTimeout(this.shellTimeOut);
            clearTimeout(this.loopTimeout);
        };

        this.nextScreen = function () {
            this.clearScreen();

            ++this.screenNum;

            this.playStatus = 0;

            this.createShells();
        };

        this.hideButtons = function () {
            $('button').hide();
            $('#refresh').show();
        };

        this.showNextButton = function () {
            this.hideButtons();

            $('#next').show();
        };

        this.showCheckButton = function () {
            this.hideButtons();

            $('#check').show();
        };

        this.delegateEvents = function () {
            self = this;

            this.$gameScreen.find(".shell > input ").each(function () {
                $(this)
                    .keyup(function () {
                        self.check();
                    })
                    .bind('paste', function (e) {
                        setTimeout(function () {
                            self.check();
                        }, 100);
                    });
            });
        };

        this.check = function () {
            var correct = 0,
                wrong = 0,
                total = this.game.configuration.game.randomShellsCount;

            this.$gameScreen.find(".shell > input").each(function () {
                var inputNodeValue = jQuery.trim($(this).val()),
                    shellId = $(this).parent('div').attr('id');

                if (inputNodeValue == shellId) {
                    ++correct;
                } else {
                    ++wrong;
                }
            });

            if (correct == total) {
                this.msgSuccess();
            } else {
                this.msgFail();
            }
        };

        this.showEndScreen = function (success) {
            var curtain = $('<div/>');
            var imageContainer = $('<div/>');
            var imgSrc;

            if (success) {
                imgSrc = 'success.png';
            } else {
                imgSrc = 'fail.png';
            }

            imageContainer
                .html('<img src="images/' + imgSrc + '" alt="">')
                .addClass('imageContainer');

            imageContainer.click(function () {
                location.reload();
            });

            curtain
                .addClass('curtain')
                .append(imageContainer);

            $('body').prepend(curtain);

            $('#refresh').addClass('btn_overlay');
        };

        this.msgSuccess = function () {
            self = this;

            this.showEndScreen(true);
        };

        this.msgFail = function () {
            self = this;

            this.showEndScreen(false);
        };
    };

    var Game = function (opts) {
        this.gameScreen = opts.gameScreen;
        this.view = new View(this, {});
        this.configuration = {
            game: {
                points: 20,             //punkty za gre
                timer: 1,               //czy wlaczyc timer?
                gameTime: 600,          //czas na rozwiazanie
                shells: 20,             //ilosc muszelek
                shellTimeOut: 1,        //czas pomiedzy wypelnieniami poszczegolnych muszelek liczba
                randomShellsScreen: 4,  //na ktorym z kolei ekranie pokazac losowe muszelki do wypelnienia
                randomShellsCount: 10   //ile muszelek ma byc pustych - do wypelnienia
            },
            messages: {
                success: 'Gratulacje!',
                fail: 'Niestety, nie udało się'
            }
        };

        this.init = function (config) {
            $.extend(this.configuration, config);
            this.view.createScreen();
        };

        this.start = function () {
            this.view.createShells();
            this.view.showScreen();
        };

        this.play = function () {
            this.view.play();
        }

        this.pause = function () {
            this.view.pause();
        }

        this.nextScreen = function () {
            this.view.nextScreen();
        }

        this.check = function () {
            this.view.check();
        }
    };

    $(function () {
        var app = new Game({
            gameScreen: "#game-container"
        });

        app.init(config);

        $("#startGame").on("click", function (e) {
            $(this).remove();
            $('#pause').show();

            app.start();

            return false;
        });

        $("#play").on("click", function (e) {
            $(this).hide();
            $('#pause').show();

            app.play();

            return false;
        });

        $("#pause").on("click", function (e) {
            $(this).hide();
            $('#play').show();

            app.pause();

            return false;
        });

        $("#next").on("click", function (e) {
            $(this).hide();
            $('#play').show();

            app.nextScreen();

            return false;
        });

        $("#check").on("click", function (e) {
            app.check();

            return false;
        });

        $("#refresh").on("click", function (e) {
            var confirmation = confirm('Czy na pewno chcesz zacząć od początku?');

            if (confirmation)
                location.reload();

            return confirmation;
        });
    });

    var config = {
        game: {
            points: 20,
            timer: 1,
            gameTime: 600,
            shells: 20,
            shellTimeOut: 1500,
            randomShellsScreen: 4,
            randomShellsCount: 10
        },
        messages: {
            success: 'Gratulacje!',
            fail: 'Niestety, nie udało się'
        }
    }
}(window, document, jQuery));
