;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    word: "{p}laża",
                    question: "Można na niej leżeć w upalne dni, opalać się i kąpać w pobliskiej wodzie, ale gdy przychodzi jesień lepiej nie rozkładaj tam ręcznika!"
                },
                {
                    word: "m{o}kre",
                    question: "Kiedy spadnie deszcz, wszystko na ziemi jest..."
                },
                {
                    word: "{g}rad",
                    question: "Małe kuleczki lecące z nieba, podobne do śniegu, ale to nie śnieg."
                },
                {
                    word: "n{o}c",
                    question: "Kiedy ona nadchodzi, słońce zachodzi."
                },
                {
                    word: "{d}ym",
                    question: "Leci z komina i z ogniska."
                },
                {
                    word: "pi{a}sek",
                    question: "Jest go mnóstwo na pustyni i w piaskownicy."
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                elements = this.settings.elements,
                $crosswordWord = $("<div><div class='inputs'></div><div class='question-container'><p class='question'></p></div></div>").addClass("word-container");

            $.each(elements, function(index, element)
            {
                var passwordIndex = element.word.search(/\{[a-z]\}/),
                    word = element.word.replace(/[\{\}]/g, ""),
                    i = 0,
                    $word = $crosswordWord.clone().appendTo(_this.$element.find(".words-container")),
                    $input = $("<input type='text' />");
                for(i = 0; i < word.length; i += 1)
                {
                    var $crossWordInput = $input.clone().attr("data-correct-value", word[i]).appendTo($word.find(".inputs"));
                    if(i === passwordIndex)
                    {
                        $crossWordInput.addClass("input-password");
                    }
                }
                $word.find(".question").text(element.question);
            });

            var $passwordInput = $("<input type='text' />");
            this.correctPassword = "";
            $.each(elements, function(index, element)
            {
                var match = element.word.match(/{[a-zA-Z]}/),
                    correctLetter = match[0].replace(/[{}]/g, "");

                $passwordInput.clone().attr("data-correct-value", correctLetter).appendTo(_this.$element.find(".password-container"));
                _this.correctPassword += correctLetter;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha",
                    valueType: "new"
                },
                inputs: {
                    next: function($input)
                    {
                        var $next = $input.next("input");
                        if($next.size())
                        {
                            return $next;
                        }
                        $next = $input.closest(".word-container").next(".word-container").find("input:first");
                        if($next.size())
                        {
                            return $next;
                        }
                        return false;
                    },
                    backspace: function($input)
                    {
                        $input.val("");
                        var $prev = $input.prev("input");
                        if (!$prev.size())
                        {
                            $prev = $input.closest(".word-container").prev(".word-container").find("input:last");
                        }
                        $prev.trigger("click").val("");
                    }
                },
                onKeyPress: function()
                {
                    _this.check();
                }
            });

            this.$element.find("input").on("keyup", function(e)
            {
                var key = e.keyCode ? e.keyCode : e.charCode,
                    $next,
                    $prev;

                if (key !== 8 && key !== 46)
                {
                    if ($(this).val())
                    {
                        $next = $(this).next("input");
                        if(!$next.size())
                        {
                            $next = $(this).closest(".word-container").next(".word-container").find("input:first");
                        }
                        $(this).trigger("blur");
                        $next.trigger("focus");
                    }
                }
                else
                {
                    $(this).val("");
                    $prev = $(this).prev("input");
                    if(!$prev.size())
                    {
                        $prev = $(this).closest(".word-container").prev(".word-container").find("input:last");
                    }
                    $prev.focus();
                }

                _this.check();
            });

            this.$element.find("input").on("click focus", function()
            {
                $(this).select();
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        check: function()
        {
            this.$element.find(".word-container").each(function()
            {
                var allFilled = true;
                $(this).removeClass("has-errors");
                $(this).find("input").each(function()
                {
                    if (!$(this).val())
                    {
                        allFilled = false;
                    }
                });

                if (allFilled)
                {
                    $(this).addClass("has-not-errors").find("input").each(function()
                    {
                        var value = $(this).val() ? $(this).val().toLowerCase() : "";
                        if (value !== $(this).attr("data-correct-value").toLowerCase())
                        {
                            $(this).closest(".word-container").addClass("has-errors").removeClass("has-not-errors");
                            return false;
                        }
                    });
                }
            });

            var isValid = this.$element.find(".word-container.has-not-errors").size() === this.settings.elements.length;
            if (isValid)
            {
                var password = "";
                this.$element.find(".password-container input").each(function()
                {
                    password += $(this).val();
                });
                if (password.toLowerCase() === this.correctPassword)
                {
                    this.$element.find(".popup, .popup-overlay").show();
                }
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);