;
(function($, window, document, undefined)
{
    var pluginName = "screenKeyboard",
        defaults = {
            keys: {
                type: "alnum", // type of keys on keyboard - num: numeric;, alnum: alpha-numeric
                filter: function(key) // custom filter function
                {
                    return true;
                },
                backspace: true,
                keys: []
            },
            inputs: {
                selectors: "input",
                next: false
            },
            height: "60%",
            margin: true
        };

    var Plugin = function Plugin(element, options)
    {
        var _this = this,
            isOn = false,
            intervalID = null;

        this.element = element;
        this.$element = $(element);
        this.$keyboard = null;
        this.settings = $.extend(true, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;

        this.init = function()
        {
            var _this = this,
                generateKeys = function generateKeys()
                {
                    var keys,
                        $key = $("<div/>")
                            .addClass("key"),
                        fnOnClickKey = function fnOnClickKey()
                        {
                            var $input = $(".screen-keyboard-input-active"),
                                inputValue = $input.val() || "",
                                keyValue = $(this).attr("data-key");

                            if(keyValue !== "backspace")
                            {
                                inputValue += keyValue;
                            }
                            else
                            {
                                inputValue = inputValue.substring(0, inputValue.length - 1);
                            }

                            if(keyValue === "backspace" && typeof _this.settings.inputs.backspace === "function")
                            {
                                _this.settings.inputs.backspace($input);
                            }
                            else
                            {
                                $input.val(inputValue).trigger("keyup");
                            }

                            if(keyValue !== "backspace" && typeof _this.settings.inputs.next === "function")
                            {
                                var $next = _this.settings.inputs.next($input);
                                if($next)
                                {
                                    $next.trigger("click");
                                }
                            }

                            return false;
                        };

                    switch(_this.settings.keys.type)
                    {
                        case "num":
                            keys = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
                            break;

                        case "alpha":
                            keys = [
                                "a", 'ą', 'b', 'c', 'ć', 'd', 'e', 'ę', 'f', 'g', 'h', 'i', 'j', 'k',
                                'l', 'ł', 'm', 'n', 'ń', 'o', 'ó', 'p', 'r', 's', 'ś', 't', 'u', 'v',
                                'w', 'x', 'y', 'z', 'ź', 'ż'
                            ];
                            break;

                        case "custom":
                            keys = _this.settings.keys.keys;
                            break;

                        default:
                            keys = [];
                            break;
                    }

                    keys = keys.filter(_this.settings.keys.filter);

                    $.each(keys, function(index, key)
                    {
                        $key
                            .clone()
                            .attr("data-key", key)
                            .text(key)
                            .appendTo(_this.$keyboard.find(".keyboard .keys-wrapper"))
                            .on("click", fnOnClickKey);
                    });

                    if(_this.settings.keys.backspace)
                    {
                        $key
                            .clone()
                            .addClass("backspace")
                            .attr("data-key", "backspace")
                            .text("")
                            .appendTo(_this.$keyboard.find(".keyboard .keys-wrapper"))
                            .on("click", fnOnClickKey);
                    }
                },
                createHTML = function createHTML()
                {
                    var html = '<div id="screen-keyboard">' +
                        '<div class="keyboard-wrapper">' +
                        '<a class="handler" href="#"></a>' +
                        '<div class="keyboard">' +
                        '<div class="keys-wrapper">' +
                        '</div>' +
                        '</div>' +
                        '</div>' +
                        '</div>';

                    _this.$keyboard = $(html).appendTo(_this.$element);
                    _this.$keyboard.css({
                        height: _this.settings.height
                    });
                    _this.handlerWidth = _this.$keyboard.find(".handler").width();
                };

            createHTML();
            generateKeys();

            this.$keyboard.find(".handler").on("click", function()
            {
                var width = $(this).closest("#screen-keyboard").width();
                if($(this).hasClass("keyboard-visible"))
                {
                    $(this).closest("#screen-keyboard").animate({
                        right: -width
                    }, 150, "linear", function()
                    {

                    });
                    $(this).animate({
                        left: -_this.handlerWidth,
                        width: _this.handlerWidth
                    }, 150, "linear", function()
                    {
                        $(this).removeClass("keyboard-visible");
                        _this.offKeyboard();
                    });
                }
                else
                {
                    $(this).closest("#screen-keyboard").animate({
                        right: 0
                    }, 150, "linear", function()
                    {

                    });
                    $(this).animate({
                        left: 0,
                        width: 40
                    }, 150, "linear", function()
                    {
                        $(this).addClass("keyboard-visible");
                        _this.onKeyboard();
                    });
                }
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.onInputClick = function(e)
            {
                $.each(_this.settings.inputs.selectors, function(key, selector)
                {
                    _this.$element.find(selector).removeClass("screen-keyboard-input-active");
                });
                $(this).addClass("screen-keyboard-input-active");
                return false;
            }
        };

        this.onKeyboard = function()
        {
            isOn = true;
            $.each(this.settings.inputs.selectors, function(index, selector)
            {
                _this.$element.find(selector).attr("readonly", "readonly");
                _this.$element.delegate(selector, "click", _this.onInputClick);
            });
            intervalID = setInterval(function()
            {
                $.each(_this.settings.inputs.selectors, function(i, selector)
                {
                    $(selector).each(function()
                    {
                        if($(this).hasClass("screen-keyboard-input-active"))
                        {
                            $(this).toggleClass("screen-keyboard-cursor");
                        }
                    });
                });
            }, 500);
            this.$element.trigger("screenKeyboard.on");
        };

        this.offKeyboard = function()
        {
            isOn = false;
            $.each(this.settings.inputs.selectors, function(index, selector)
            {
                _this.$element.find(selector).removeAttr("readonly");
                _this.$element.undelegate(selector, "click", _this.onInputClick);
            });
            this.$element.find(".screen-keyboard-input-active").removeClass("screen-keyboard-input-active");
            clearInterval(intervalID);
            this.$element.trigger("screenKeyboard.off");
        };

        this.isKeyboardOn = function()
        {
            return isOn;
        };

        this.hideKeyboard = function()
        {
            this.$keyboard.find(".handler.keyboard-visible").trigger("click");
        };

        this.showKeyboard = function()
        {
            this.$keyboard.find(".handler:not(.keyboard-visible").trigger("click");
        };

        this.resize = function()
        {
            var height = -Math.floor(this.$keyboard.height() / 2);
            if(this.settings.margin)
            {
                this.$keyboard.css("margin-top", height + "px");
            }

            if(!this.$keyboard.find(".handler").hasClass("keyboard-visible"))
            {
                var width = this.$keyboard.width();
                this.$keyboard.css({
                    right: -width
                });
            }

            var keySize = 500,
                rows = this.$keyboard.find(".key").size(),
                containerHeight = this.$keyboard.find(".keyboard-wrapper").height() - 100,
                containerWidth = this.$keyboard.find(".keyboard-wrapper").width() - 100,
                marginBottom = 5,
                marginRight = 5,
                elementsPerRow = 1,
                elementsCount = this.$keyboard.find(".key").size();

            while(rows * (keySize + marginBottom) > containerHeight)
            {
                keySize -= 5;
                elementsPerRow = Math.floor(containerWidth / (keySize + marginRight));
                rows = Math.ceil(elementsCount / elementsPerRow);
            }

            this.$keyboard.find(".key").height(keySize).width(keySize).css({
                lineHeight: keySize + "px",
                fontSize: (keySize * 0.8) + "px"
            });

            this.$keyboard.find(".key.backspace").css({
                backgroundSize: (keySize * 0.8) + "px",
                fontSize: 0,
                lineHeight: 0
            });
        };

        this.init();
    };

    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);