;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            tab1: {
                elements: [
                    {
                        equation: "6 + 9",
                        letter: "P"
                    },
                    {
                        equation: "5 + 7",
                        letter: "O"
                    },
                    {
                        equation: "10 + 6",
                        letter: "N"
                    },
                    {
                        equation: "4 + 9",
                        letter: "Z"
                    },
                    {
                        equation: "7 + 7",
                        letter: "R"
                    },
                    {
                        equation: "5 + 6",
                        letter: "G"
                    },
                    {
                        equation: "3 + 7",
                        letter: "A"
                    },
                    {
                        equation: "6 + 2",
                        letter: "D"
                    },
                    {
                        equation: "2 + 5",
                        letter: "Y"
                    }
                ],
                password: [
                    {
                        correctValue: "p",
                        number: 15
                    },
                    {
                        correctValue: "r",
                        number: 14
                    },
                    {
                        correctValue: "o",
                        number: 12
                    },
                    {
                        correctValue: "g",
                        number: 11
                    }
                    ,
                    {
                        correctValue: "n",
                        number: 16
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 12
                    }
                    ,
                    {
                        correctValue: "z",
                        number: 13
                    }
                    ,
                    {
                        correctValue: "a",
                        number: 10
                    }
                    ,
                    {
                        correctValue: "p",
                        number: 15
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 12
                    }
                    ,
                    {
                        correctValue: "g",
                        number: 11
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 12
                    }
                    ,
                    {
                        correctValue: "d",
                        number: 8
                    }
                    ,
                    {
                        correctValue: "y",
                        number: 7
                    }
                ]
            },
            tab2: {
                elements: [
                    {
                        equation: "9 + 8",
                        letter: "P"
                    },
                    {
                        equation: "8 + 7",
                        letter: "O"
                    },
                    {
                        equation: "10 + 8",
                        letter: "N"
                    },
                    {
                        equation: "9 + 10",
                        letter: "Z"
                    },
                    {
                        equation: "5 + 11",
                        letter: "R"
                    },
                    {
                        equation: "9 + 12",
                        letter: "G"
                    },
                    {
                        equation: "10 + 10",
                        letter: "A"
                    },
                    {
                        equation: "11 + 1",
                        letter: "D"
                    },
                    {
                        equation: "15 - 2",
                        letter: "Y"
                    }
                ],
                password: [
                    {
                        correctValue: "p",
                        number: 17
                    },
                    {
                        correctValue: "r",
                        number: 16
                    },
                    {
                        correctValue: "o",
                        number: 15
                    },
                    {
                        correctValue: "g",
                        number: 21
                    }
                    ,
                    {
                        correctValue: "n",
                        number: 18
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 15
                    }
                    ,
                    {
                        correctValue: "z",
                        number: 19
                    }
                    ,
                    {
                        correctValue: "a",
                        number: 20
                    }
                    ,
                    {
                        correctValue: "p",
                        number: 17
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 15
                    }
                    ,
                    {
                        correctValue: "g",
                        number: 21
                    }
                    ,
                    {
                        correctValue: "o",
                        number: 15
                    }
                    ,
                    {
                        correctValue: "d",
                        number: 12
                    }
                    ,
                    {
                        correctValue: "y",
                        number: 13
                    }
                ]
            }
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            this.createPassword(this.settings.tab1.password);
            this.createElements(this.settings.tab1.elements);

            _this.$element.find(".tab").on("click", function()
            {
                var $this = $(this).toggleClass("hard");
                if($this.hasClass("hard"))
                {
                    $this.text("Poziom łatwy");
                    _this.$element.find(".next").hide();
                    _this.createPassword(_this.settings.tab2.password);
                    _this.createElements(_this.settings.tab2.elements);
                }
                else
                {
                    $this.text("Poziom trudny");
                    _this.$element.find(".next").show();
                    _this.createPassword(_this.settings.tab1.password);
                    _this.createElements(_this.settings.tab1.elements);
                }
            });

            _this.$element.find(".popup.popup-result .next").on("click", function()
            {
                _this.$element.find(".popup.popup-result, .popup-overlay").hide();
                _this.$element.find(".tab").trigger("click");
                return false;
            });


            this.$element.find(".popup.popup-instruction .next").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        return $input.closest("td").next().find("input");
                    }
                }
            });

            _this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        createPassword: function(passwordElements)
        {
            var _this = this,
                $inputCell = $("<td><input type='text' /></td>"),
                $legendCell = $("<th></th>");

            this.$element.find(".table td, .table th").remove();

            $.each(passwordElements, function(i, obj)
            {
                var $iC = $inputCell.clone()
                        .find("input").attr("data-correct-value", obj.correctValue).end()
                        .appendTo(_this.$element.find("table .has-inputs")),
                    $lC = $legendCell.clone()
                        .text(obj.number)
                        .appendTo(_this.$element.find("table .has-legend"));
            });

            this.$element.find(".table input").on("keyup", function(e)
            {
                var key = e.keyCode ? e.keyCode : e.charCode,
                    $next,
                    $prev;

                if(key !== 8 && key !== 46)
                {
                    if($(this).val())
                    {
                        $next = $(this).closest("td").next("td").find("input");
                        $(this).trigger("blur");
                        $next.trigger("focus");
                    }
                }
                else
                {
                    $(this).val("");
                    $prev = $(this).closest("td").prev("td").find("input");
                    $prev.trigger("focus").select();
                }

                _this.check();
            }).on("blur", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect");

                if($this.val())
                {
                    if($this.val().toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.addClass("result-correct");
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                }

                _this.check();
            });
        },
        createElements: function(arrElements)
        {
            var _this = this,
                $element = $("<div><span/></div>").addClass("element"),
                elements = [];

            this.$element.find(".element").remove();

            $.each(arrElements, function(i, obj)
            {
                var $el = $element.clone()
                    .find("span").text(obj.equation + " => " + obj.letter).end()
                    .appendTo(_this.$element.find(".elements"));

                elements.push($el);
            });

            $.each(elements, function(i, $el)
            {
                var left = i % 3 * 33 - Math.floor(Math.random() * 5),
                    top = Math.floor(i / 3) * 33 - Math.floor(Math.random() * 5);

                left = Math.abs(left);
                top = Math.abs(top);

                $el.css({
                    top: top + "%",
                    left: left + "%"
                });
            });
        },
        check: function()
        {
            if (this.$element.find(".table input.result-correct").size() === this.$element.find(".table input").size())
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        },
        resize: function()
        {
            var nbPasswordElements = this.settings.tab1.password.length,
                tableWidth = this.$element.find(".table").width();

            this.$element.find(".table td").width(tableWidth / nbPasswordElements);
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);