;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {};

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            $('input').val('');
            var _this = this;

            this.activeEquation = -1;

            this.$element.find("input").on("keyup", function()
            {
                var $this = $(this).removeClass("value-correct").removeClass("value-incorrect"),
                    correctValue = $this.attr("data-correct-value").replace(/\s+/g, ""),
                    value = $this.val() ? $this.val().replace(/\s+/g, "") : "";

                $(this).closest(".equation-container").find(".next").hide();

                if(value === correctValue)
                {
                    $(this).addClass("value-correct");
                    $(this).closest(".equation-container").find(".next").css("display", "block");
                    _this.check();
                }
            }).on("blur", function()
            {
                var $this = $(this),
                    correctValue = $this.attr("data-correct-value").replace(/\s+/g, ""),
                    value = $this.val() ? $this.val().replace(/\s+/g, "") : "";

                if(value && value !== correctValue)
                {
                    $this.addClass("value-incorrect").removeClass("value-correct");
                }
            });

            this.$element.find(".next").on("click", function()
            {
                if($(this).closest(".equation-container").find("input").hasClass("value-correct"))
                {
                    _this.showNextEquation();
                }
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".popup .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "custom",
                    keys: [1, 2, 3, 4, 5, 6, 7, 8, 9, 0, "-", "+", "="]
                },
                inputs: {
                    selectors: ["input"]
                }
            }).on("screenKeyboard.on", function () {
                $('#game').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('#game').removeClass("screen-keyboard-on");
            });
            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".equation-container.is-active input").trigger("click");
            });

            this.showNextEquation();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        showNextEquation: function()
        {
            this.activeEquation += 1;
            this.$element.find(".equation-container.is-active").removeClass("is-active");
            this.$element.find(".equation-container").eq(this.activeEquation).addClass("is-active");

            if(this.$element.data("plugin_screenKeyboard").isKeyboardOn())
            {
                this.$element.find(".equation-container").eq(this.activeEquation).find("input").trigger("click");
            }
        },
        check: function()
        {
            if(this.$element.find("input.value-correct").size() === this.$element.find("input").size())
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);