$(function () {

    $('div.box').draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);

            $(this).css('z-index', '2');
        },
        revert: function (dropped) {
            var parent = $(this).parent();
            var dropped = dropped && dropped[0].id == "droppable";

            if (!dropped) {
                if (parent.hasClass('season')) {
                    if (parent.attr('id') == 'fall' || parent.attr('id') == 'winter') {
                        var parentBot = parent.outerHeight() - $(this).outerHeight() - 10;
                        $(this).data("ui-draggable").originalPosition = {top: parentBot, left: 0};
                    } else {
                        $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                    }
                }
                if (parent.hasClass('middle')) {
                    $(this).data("ui-draggable").originalPosition = {top: '20%', left: '50%'};
                }
                if (parent.attr('id') == 'box-wrapper') {
                    $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                    $(this).css('margin-right', '4px');
                }
                $(this).appendTo($(this).data('originalParent'));
            }
            return !dropped;
        }
    });


    $('div.season').droppable({
        accept: "div.box",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            if ($(this).find('.box').length < 2) {
                ui.draggable.data('dropped', true);
                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                })
                    .appendTo(this);
                ui.draggable.data('seasonParent', $(this).attr('id'));
            }
        }
    });

    $('.middle').droppable({
        accept: "div.box",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            if ($(this).find('.box').length < 1) {
                ui.draggable.data('dropped', true);
                $(ui.draggable).detach().appendTo(this).css({
                    top: 0,
                    left: 0
                });

                ui.draggable.data('seasonParent', $(this).attr('id'));

            }
        }
    });

    $('#box-wrapper').droppable({
        accept: "div.box",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {

            ui.draggable.data('dropped', true);
            $(ui.draggable).detach().appendTo(this).css({
                top: 0,
                left: 0
            });

            ui.draggable.data('seasonParent', $(this).attr('id'));


        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this);
            });
        return this
    };

    // $('div.box').randomize();

});

