;
(function($, window, document, undefined)
{
    $('body').delegate('#success', 'click', function() {
        $(this).hide();
        $('.popup-overlay').hide();
        return false;
    });

    var pluginName = "game",
        defaults = {
            elements: [
                {
                    txt: "kwiecień",
                    groups: [2],
                    index: 0
                },
                {
                    txt: "maj",
                    groups: [2],
                    index: 1
                },
                {
                    txt: "czerwiec",
                    groups: [2, 3],
                    index: 2
                },
                {
                    txt: "lipiec",
                    groups: [3],
                    index: 3
                },
                {
                    txt: "sierpień",
                    groups: [3],
                    index: 4
                },
                {
                    txt: "wrzesień",
                    groups: [3, 4],
                    index: 5
                },
                {
                    txt: "październik",
                    groups: [4],
                    index: 6
                },
                {
                    txt: "listopad",
                    groups: [4],
                    index: 7
                },
                {
                    txt: "grudzień",
                    groups: [4, 1],
                    index: 8
                },
                {
                    txt: "styczeń",
                    groups: [1],
                    index: 9
                },
                {
                    txt: "luty",
                    groups: [1],
                    index: 10
                },
                {
                    txt: "marzec",
                    groups: [1, 2],
                    index: 11
                }
            ]
        },
        colors = ["#eb0165", "#f8a31b", "#1793fd", "#ede863"];

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.currentColor = 0;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            this.points = 0;

            var _this = this,
                elementsCount = this.settings.elements.length,
                angle = 0,
                angleIncrease = Math.PI * 2 / elementsCount,
                $element = $("<div/>").addClass("element");

            $.each(this.settings.elements, function(index, el)
            {
                var $el = $element.clone().text(el.txt).appendTo(_this.$element.find(".elements-container")),
                    width = $el.width(),
                    height = $el.height();

                $el.css({
                    left: 250 * Math.cos(angle) + 325 - (width / 2),
                    top: 250 * Math.sin(angle) + 325 - (height / 2)
                });

                angle += angleIncrease;
            });

            var i,
                $season = $("<div/>").addClass("season");
            angle = 0;
            angleIncrease = Math.PI * 2 / 4;
            $.each(["wiosna", "lato", "jesień", "zima"], function(index, season)
            {
                var $el = $season.clone().text(season).appendTo(_this.$element.find(".elements-container")),
                    width = $el.width(),
                    height = $el.height();

                $el.css({
                    left: 100 * Math.cos(angle) + 325 - (width / 2),
                    top: 100 * Math.sin(angle) + 325 - (height / 2)
                });

                angle += angleIncrease;
            });

            this.createCanvas();

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        createCanvas: function()
        {
            var $canvas = $("<canvas/>").attr("width", 650).attr("height", 650),
                canvas = $canvas[0],
                ctx = canvas.getContext("2d"),
                _this = this;

            $canvas.appendTo(".canvas-container");
            $canvas.on("mousedown tapstart touchstart", function(e)
            {
                var offset = $(this).offset(),
                    x = e.pageX - offset.left,
                    y = e.pageY - offset.top;

                if (e.originalEvent && e.originalEvent.touches)
                {
                    x = e.originalEvent.touches[0].pageX - offset.left;
                    y = e.originalEvent.touches[0].pageY - offset.top;
                    if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1) // firefox bug fix
                    {
                        //y = $canvas.height() - y;
                    }
                }
                _this.isDrawing = true;
                ctx.lineWidth = 10;
                ctx.lineJoin = ctx.lineCap = "round";
                ctx.strokeStyle = colors[_this.currentColor];
                ctx.moveTo(x, y);
            }).on("mousemove tapmove touchmove", function(e)
            {
                var offset = $(this).offset(),
                    x = e.pageX - offset.left,
                    y = e.pageY - offset.top;

                if(e.originalEvent && e.originalEvent.touches)
                {
                    x = e.originalEvent.touches[0].pageX - offset.left;
                    y = e.originalEvent.touches[0].pageY - offset.top;
                    if (navigator.userAgent.toLowerCase().indexOf('firefox') > -1) // firefox bug fix
                    {
                        //y = $canvas.height() - y;
                    }
                }

                if(_this.isDrawing)
                {
                    ctx.lineTo(x, y);
                    ctx.stroke();
                }
            }).on("mouseup tapend touchend", function(e)
            {
                if(_this.isDrawing)
                {
                    _this.isDrawing = false;
                    ctx.closePath();
                    if(_this.check($canvas, ctx))
                    {
                        _this.currentColor += 1;
                    }
                    _this.createCanvas();
                }
            });
        },
        check: function($canvas, ctx)
        {
            var i, j,
                position1,
                position2,
                position3,
                position4,
                _this = this,
                x, y,
                failed = 0,
                elements = this.settings.elements,
                group,
                relatedElements;

            for(i = 0; i < elements.length; i += 3)
            {
                group = elements[i].groups[0];

                relatedElements = this.findElementsByGroup(group);

                x = parseInt(_this.$element.find(".element").eq(relatedElements[0].index).css("left"));
                y = parseInt(_this.$element.find(".element").eq(relatedElements[0].index).css("top"));
                position1 = [x, y];

                x = parseInt(_this.$element.find(".element").eq(relatedElements[1].index).css("left"));
                y = parseInt(_this.$element.find(".element").eq(relatedElements[1].index).css("top"));
                position2 = [x, y];

                x = parseInt(_this.$element.find(".element").eq(relatedElements[2].index).css("left"));
                y = parseInt(_this.$element.find(".element").eq(relatedElements[2].index).css("top"));
                position3 = [x, y];

                x = parseInt(_this.$element.find(".element").eq(relatedElements[3].index).css("left"));
                y = parseInt(_this.$element.find(".element").eq(relatedElements[3].index).css("top"));
                position4 = [x, y];

                if(ctx.isPointInPath(position1[0], position1[1]) && ctx.isPointInPath(position2[0], position2[1])
                    && ctx.isPointInPath(position3[0], position3[1]) && ctx.isPointInPath(position4[0], position4[1]))
                {

                }
                else
                {
                    failed += 1;
                }

            }

            if(failed === 4)
            {
                ctx.strokeStyle = "#f00";
                ctx.stroke();
                $canvas.fadeOut(2000, function()
                {
                    $(this).remove();
                });
                return false;
            }
            else
            {
                this.points += 1;
                if(this.points === 4) {
                    $('.popup-overlay').show();
                    $('#success').show();
                }
                //ctx.strokeStyle = "#0f0";
                ctx.stroke();
                return true;
            }

        },
        findElementsByGroup: function(group)
        {
            var result = [];
            $.each(this.settings.elements, function(index, el)
            {
                if(el.groups.indexOf(group) > -1)
                {
                    result.push(el);
                }
            });
            return result;
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);