<?php

$hasheading = ($PAGE->heading);
$hasnavbar = (empty($PAGE->layout_options['nonavbar']) && $PAGE->has_navbar());
$hasfooter = (empty($PAGE->layout_options['nofooter']));
$hassidepre = (empty($PAGE->layout_options['noblocks']) && $PAGE->blocks->region_has_content('side-pre', $OUTPUT));
$haslogininfo = (empty($PAGE->layout_options['nologininfo']));

$showsidepre = ($hassidepre && !$PAGE->blocks->region_completely_docked('side-pre', $OUTPUT));

$custommenu = $OUTPUT->custom_menu();
$hascustommenu = (empty($PAGE->layout_options['nocustommenu']) && !empty($custommenu));

$bodyclasses = array();
if (!$showsidepre) {
    $bodyclasses[] = 'content-only';
}
if ($hascustommenu) {
    $bodyclasses[] = 'has_custom_menu';
}

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes() ?>>
<head>
    <title><?php echo $PAGE->title ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->pix_url('favicon', 'theme')?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
	<link rel="stylesheet" type="text/css" href="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/style/kwp.css">
</head>
<body id="<?php p($PAGE->bodyid) ?>" class="<?php p($PAGE->bodyclasses.' '.join(' ', $bodyclasses)) ?>">
<?php echo $OUTPUT->standard_top_of_body_html() ?>

<div id="headerbar">
	<a href="<?php echo $CFG->wwwroot; ?>" id="headerlogo"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/style/kwp/logo.png" alt="Kreatywnie w przedsiębiorczość"></a>
</div>
<div id="mainmenu">
				<ul id="yw0">
<li><a href="http://kreatywnie.lublin.eu/">Gra</a></li>
<li class="active"><a href="http://kreatywnie.lublin.eu/elearning/">Platforma edukacyjna</a></li>
<li><a href="http://kreatywnie.lublin.eu/index.php/teacher/main/index">Panel nauczyciela</a></li>
</ul>			</div>

<div id="page">
<?php if ($hasheading || $hasnavbar) { ?>
    <div id="page-header">
        <?php if ($hasheading) { ?>
        <h1 class="headermain"><?php echo $PAGE->heading ?></h1>
        <div class="headermenu"><?php
            if ($haslogininfo) {
                echo $OUTPUT->login_info();
            }
            if (!empty($PAGE->layout_options['langmenu'])) {
                echo $OUTPUT->lang_menu();
            }
            echo $PAGE->headingmenu
        ?></div><?php } ?>
        <?php if ($hascustommenu) { ?>
        <div id="custommenu"><?php echo $custommenu; ?></div>
        <?php } ?>
        <?php if ($hasnavbar) { ?>
            <div class="navbar clearfix">
                <div class="breadcrumb"><?php echo $OUTPUT->navbar(); ?></div>
                <div class="navbutton"> <?php echo $PAGE->button; ?></div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
<!-- END OF HEADER -->

    <div id="page-content" class="clearfix">
        <div id="report-main-content">
            <div class="region-content">
                <?php echo $OUTPUT->main_content() ?>
            </div>
        </div>
        <?php if ($hassidepre) { ?>
        <div id="report-region-wrap">
            <div id="report-region-pre" class="block-region">
                <div class="region-content">
                    <?php echo $OUTPUT->blocks_for_region('side-pre') ?>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>

<!-- START OF FOOTER -->
    <?php if ($hasfooter) { ?>
    <div id="page-footer" class="clearfix">
        <p class="helplink"><?php echo page_doc_link(get_string('moodledocslink')) ?></p>
        <?php
        echo $OUTPUT->login_info();
        echo $OUTPUT->home_link();
        echo $OUTPUT->standard_footer_html();
        ?>
		<div id="footer" style="padding: 10px; position: relative; bottom: 0px;">
			<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo-pokl.png" class="footer footerLogo-left" alt="POKL"></a>
			<a href="http://www.pollub.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo5.png" class="footer footerLogo-center" alt="Politechnika Lubelska"></a>
			<a href="http://inkubator.pollub.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo4.png" class="footer footerLogo-center" alt="Lubelski Inkubator Przedsiêorczo¶ci Politechniki Lubelskiej"></a>
			<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo3.png" class="footer footerLogo-center" alt="Lublin inspiruje biznes"></a>
			<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo1.png" class="footer footerLogo-center" alt="Herb Lublina"></a>
			<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo-ue.png" class="footer footerLogo-right" alt="UE"></a>
			<div id="footer-txt">Projekt współfinansowany ze środków Unii Europejskiej w ramach Europejskiego Funduszu Społecznego.</div>
		</div>
		<div class="clearfix"></div>
    </div>
    <?php } ?>
    <div class="clearfix"></div>
</div>
<?php echo $OUTPUT->standard_end_of_body_html() ?>
</body>
</html>