<?php

$hassidepre = $PAGE->blocks->region_has_content('side-pre', $OUTPUT);
$hassidepost = $PAGE->blocks->region_has_content('side-post', $OUTPUT);
$showsidepre = $hassidepre && !$PAGE->blocks->region_completely_docked('side-pre', $OUTPUT);
$showsidepost = $hassidepost && !$PAGE->blocks->region_completely_docked('side-post', $OUTPUT);

$custommenu = $OUTPUT->custom_menu();
$hascustommenu = (empty($PAGE->layout_options['nocustommenu']) && !empty($custommenu));

$bodyclasses = array();
if ($showsidepre && !$showsidepost) {
    if (!right_to_left()) {
        $bodyclasses[] = 'side-pre-only';
    }else{
        $bodyclasses[] = 'side-post-only';
    }
} else if ($showsidepost && !$showsidepre) {
    if (!right_to_left()) {
        $bodyclasses[] = 'side-post-only';
    }else{
        $bodyclasses[] = 'side-pre-only';
    }
} else if (!$showsidepost && !$showsidepre) {
    $bodyclasses[] = 'content-only';
}
if ($hascustommenu) {
    $bodyclasses[] = 'has_custom_menu';
}

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes() ?>>
<head>
    <title><?php echo $PAGE->title ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->pix_url('favicon', 'theme')?>" />
    <meta name="description" content="<?php p(strip_tags(format_text($SITE->summary, FORMAT_HTML))) ?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
	<link rel="stylesheet" type="text/css" href="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/style/kwp.css">
</head>
<body id="<?php p($PAGE->bodyid) ?>" class="<?php p($PAGE->bodyclasses.' '.join(' ', $bodyclasses)) ?>">
<?php echo $OUTPUT->standard_top_of_body_html() ?>

<div id="headerbar">
	<a href="<?php echo $CFG->wwwroot; ?>" id="headerlogo"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/style/kwp/logo.png" alt="Kreatywnie w przedsiębiorczość"></a>
</div>
<div id="mainmenu">
				<ul id="yw0">
<li><a href="http://kreatywnie.lublin.eu/">Gra</a></li>
<li class="active"><a href="http://kreatywnie.lublin.eu/elearning/">Platforma edukacyjna</a></li>
<li><a href="http://kreatywnie.lublin.eu/index.php/teacher/main/index">Panel nauczyciela</a></li>
</ul>			</div>

<div id="page">

    <div id="page-header" class="clearfix">
        <h1 class="headermain"><?php echo $PAGE->heading ?></h1>
        <div class="headermenu"><?php
            echo $OUTPUT->login_info();
            //echo $OUTPUT->lang_menu();
            echo $PAGE->headingmenu;
        ?></div>
        <?php if ($hascustommenu) { ?>
        <div id="custommenu"><?php echo $custommenu; ?></div>
         <?php } ?>
            <div class="navbar clearfix">
                <div class="breadcrumb"><?php echo $OUTPUT->navbar(); ?></div>
                <div class="navbutton"> <?php echo $PAGE->button; ?></div>
            </div>
    </div>
<!-- END OF HEADER -->

    <div id="page-content">
        <div id="region-main-box">
            <div id="region-post-box">

                <div id="region-main-wrap">
                    <div id="region-main">
                        <div class="region-content">
                            <?php echo $OUTPUT->main_content() ?>
                        </div>
                    </div>
                </div>

                <?php if ($hassidepre OR (right_to_left() AND $hassidepost)) { ?>
                <div id="region-pre" class="block-region">
                    <div class="region-content">
                            <?php
                        if (!right_to_left()) {
                            echo $OUTPUT->blocks_for_region('side-pre');
                        } elseif ($hassidepost) {
                            echo $OUTPUT->blocks_for_region('side-post');
                    } ?>

                    </div>
                </div>
                <?php } ?>

                <?php if ($hassidepost OR (right_to_left() AND $hassidepre)) { ?>
                <div id="region-post" class="block-region">
                    <div class="region-content">
                           <?php
                       if (!right_to_left()) {
                           echo $OUTPUT->blocks_for_region('side-post');
                       } elseif ($hassidepre) {
                           echo $OUTPUT->blocks_for_region('side-pre');
                    } ?>
                    </div>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>

<!-- START OF FOOTER -->
    <div id="page-footer">
        <p class="helplink">
        <?php echo page_doc_link(get_string('moodledocslink')) ?>
        </p>

        <?php
        echo $OUTPUT->login_info();
        //echo $OUTPUT->home_link();
        echo $OUTPUT->standard_footer_html();
?>
<div id="footer" style="padding: 10px; position: relative; bottom: 0px;">
			<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo-pokl.png" class="footer footerLogo-left" alt="POKL"></a>
			<a href="http://www.pollub.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo5.png" class="footer footerLogo-center" alt="Politechnika Lubelska"></a>
			<a href="http://inkubator.pollub.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo4.png" class="footer footerLogo-center" alt="Lubelski Inkubator Przedsiêorczo¶ci Politechniki Lubelskiej"></a>
			<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo3.png" class="footer footerLogo-center" alt="Lublin inspiruje biznes"></a>
			<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo1.png" class="footer footerLogo-center" alt="Herb Lublina"></a>
			<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo $CFG->wwwroot .'/theme/'. current_theme() ?>/pix/kwp/logo-ue.png" class="footer footerLogo-right" alt="UE"></a>
			<div id="footer-txt">Projekt współfinansowany ze środków Unii Europejskiej w ramach Europejskiego Funduszu Społecznego.</div>
		</div>
    </div>
    <div class="clearfix"></div>
</div>
<?php echo $OUTPUT->standard_end_of_body_html() ?>
</body>
</html>
