;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    img: "img/family/Krystyna.png",
                    correctPosition: 5,
                    text: "Mam na imię Krystyna i jestem o 30 lat starsza od mojej córki.",
                    textClass: "text-1"
                },
                {
                    img: "img/family/Zosia.png",
                    correctPosition: 0,
                    text: "Mam na imię Zosia i jestem o cztery lata młodsza od Tomka",
                    textClass: "text-2"
                },
                {
                    img: "img/family/Kasia.png",
                    correctPosition: 3,
                    text: "Mam na imię Kasia, jestem żoną Roberta, mam 37 lat.",
                    textClass: "text-3"
                },
                {
                    img: "img/family/Franek.png",
                    correctPosition: 1,
                    text: "Mam na imię Franek i mam 8 lat.",
                    textClass: "text-4"
                },
                {
                    img: "img/family/Robert.png",
                    correctPosition: 4,
                    text: "Mam na imię Robert i jestem o 5 lat starszy od mojej żony.",
                    textClass: "text-5"
                },
                {
                    img: "img/family/Tomek.png",
                    correctPosition: 2,
                    text: "Mam na imię Tomek i jestem o dwa lata starszy od Franka.",
                    textClass: "text-6"
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                $container = this.$element.find(".container");

            $.each(this.settings.elements, function(key, obj)
            {
                var $element = $("<div><p class='text'></p></div>")
                    .addClass("element")
                    .attr("data-correct-position", obj.correctPosition)
                    .append( $("<img/>").attr("src", obj.img) )
                    .find(".text").text(obj.text).addClass(obj.textClass).end()
                    .appendTo($container);
            });

            $container
                .sortable()
                .on("sortstop", function()
                {
                    _this.check();
                });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            if (window.navigator.userAgent.indexOf("MSIE") > -1 || !!window.navigator.userAgent.match(/Trident.*rv:11\./))
            {
                this.$element.addClass("ie");
            }
        },
        resize: function()
        {
            this.$element.find(".container").css("line-height", $(window).height() + "px");
        },
        check: function()
        {
            var position = 0,
                result = true;
            this.$element.find(".element").each(function()
            {
                var elementPosition = parseInt($(this).attr("data-correct-position"));
                if (position !== elementPosition)
                {
                    result = false;
                }
                position += 1;
            });

            if (result)
            {
                this.$element.find(".popup.result-success, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - 0.5;
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);