;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    text: "poniedziałek",
                    correctValue: 1
                },
                {
                    text: "wtorek",
                    correctValue: 2
                },
                {
                    text: "środa",
                    correctValue: 3
                },
                {
                    text: "czwartek",
                    correctValue: 4
                },
                {
                    text: "piątek",
                    correctValue: 5
                },
                {
                    text: "sobota",
                    correctValue: 6
                },
                {
                    text: "niedziela",
                    correctValue: 7
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                $element = $("<div><p><span></span></p><input type='text' /></div>").addClass("element"),
                onKeyUp = function onKeyUp()
                {
                    var $this = $(this).removeClass("correct-value").removeClass("incorrect-value"),
                        value = $this.val();

                    if(value)
                    {
                        if(value === $this.attr("data-correct-value"))
                        {
                            $this.addClass("correct-value");
                        }
                        else
                        {
                            $this.addClass("incorrect-value");
                        }
                        _this.check();
                    }
                };

            $.each(this.settings.elements, function(key, obj)
            {
                var $el = $element.clone()
                    .find("p span").text(obj.text).end()
                    .find("input").attr("data-correct-value", obj.correctValue).on("keyup", onKeyUp).end()
                    .appendTo(_this.$element.find(".elements-wrapper"));
            });

            this.$element.find(".element").randomize();

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "num"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.val() && $input.val() === $input.attr("data-correct-value"))
                        {
                            return $input.closest(".element").next(".element").find("input");
                        }
                    }
                }
            });

            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find("input:first").trigger("click");
            }).on("screenKeyboard.on", function () {
                $('#game').find(".equation.is-visible input").trigger("click");
                $('.elements-wrapper').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('.elements-wrapper').removeClass("screen-keyboard-on");
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup-instruction, .popup-overlay").show();

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });
        },
        resize: function()
        {
            this.$element.find(".elements-wrapper .element p").css("line-height", (this.$element.find(".elements-wrapper .element").height() - 20) + "px");
        },
        check: function()
        {
            if(this.$element.find(".element input.correct-value").size() === this.settings.elements.length)
            {
                this.$element.find(".popup-result, .popup-overlay").show();
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);