;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {

        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            this.activeEquation = -1;

            this.$element.find("input").on("keyup", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect");
                $this.closest(".equation-container").find(".next").hide();

                if ($this.val())
                {
                    if ($this.val() === $this.attr("data-correct-value"))
                    {
                        $this.addClass("result-correct");
                        $this.closest(".equation-container").find(".next").css("display", "block");
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                }

                _this.check();
            });

            this.$element.find(".next").on("click", function()
            {
                if ($(this).closest(".equation-container").find("input").hasClass("result-correct"))
                {
                    _this.showNextEquation();
                }
                return false;
            });

            this.showNextEquation();

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "num"
                },
                inputs: {
                    selectors: ["input"]
                },
                onKeyPress: function()
                {
                    _this.check();
                }
            });

            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".equation-container.is-active input").trigger("click");
            });
        },
        showNextEquation: function()
        {
            this.activeEquation += 1;
            this.$element.find(".equation-container.is-active").removeClass("is-active");
            this.$element.find(".equation-container").eq(this.activeEquation).addClass("is-active").find("input").trigger("click");
        },
        check: function()
        {
            var _this = this;

            if (this.$element.find("input.result-correct").size() === this.$element.find("input").size())
            {
                _this.$element.data("plugin_screenKeyboard").hideKeyboard();
                _this.$element.find(".popup, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);