(function($) {
    $.fn.randomize = function(childElem) {
        function shuffle(o) {
            for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);

            return o;
        };

        return this.each(function() {
            var $this = $(this);
            var elems = $this.children(childElem);

            shuffle(elems);

            $this.detach(childElem);  

            for( var i=0; i < elems.length; i++ ) {
                $this.append(elems[i]);      
            }
        });    
    }
})(jQuery);

$(document).ready(function() {

    $('#labels').randomize('.label');

    $('#labels').find(".label").draggable({
        revert: true,
        helper: "clone",
        cursor: "move",
        cursorAt: {
            top: 20,
            left: 20
        }
    });

    $("#labels").droppable({
        accept: '.placeholder',
        tolerance: "pointer",
        drop: function(evt, ui)
        {
            var id = $(ui.draggable).data('id');
            var name;
            var multi = '';

            if( $(ui.draggable).hasClass('filled-multi') ) {
                var multi = (ui.draggable).html().split(',');
                name = $.trim(multi[0]);

                multi.shift();

                multi = multi.join(', ');
            } else {
                name = $.trim($(ui.draggable).html());
            }

            $(this).append('<span class="label" data-id="'+id+'">'+name+'</span>');

            $('#labels').find(".label").draggable({
                revert: true,
                helper: "clone",
                cursor: "move",
                cursorAt: {
                    top: 20,
                    left: 20
                }
            });

            $(ui.draggable)
            .html(multi)
            .removeClass('filled');

            $('#labels').removeClass('highlighted');
        },
        over: function(event, ui)
        {
            $('#labels').addClass('highlighted');
        },
        out: function(event, ui)
        {
            $('#labels').removeClass('highlighted');
        }
    });

    $("#textContainer").find(".placeholder").droppable({
        accept: '.label',
        tolerance: "pointer",
        drop: function(evt, ui)
        {
            var multiPlaceholder = $(this).data('multi') ? true : false;

            if( !multiPlaceholder && $(this).hasClass('filled') ) {
                $(this).removeClass('active-drop');

                return true;
            }

            var labelText = $(ui.draggable).text();
            var labelId = $(ui.draggable).data('id');

            var labelsLeft = $('#labels').find(".label").length;

            $('.ui-draggable-dragging').hide();

            if( multiPlaceholder) {
                labelText = $(this).text() + labelText + ', ';
            }

            $(this)
            .text(labelText)
            .removeClass('active-drop')
            .addClass('filled')
            .data('label-id', labelId)
            .attr('data-label-id', labelId);

            if( multiPlaceholder) {
                $(this).addClass('filled-multi');

                if( labelsLeft == 2 ) {
                    $('.multi').removeClass('filled-multi');
                }
            }

            $(ui.draggable).remove();

            if( labelsLeft == 2 ) {
                var multiLabelText = $('.multi').text();

                $('.multi').text(multiLabelText.replace(/^,|, $/g,''));

                check();
            }

            $('.placeholder.filled').draggable({
                revert: false,
                helper: "clone",
                cursor: "move",
                cursorAt: {
                    top: 40,
                    left: 20
                },
                start: function(event, ui) {
                    $(ui.draggable).addClass('active-dragg');
                }
            });
        },
        over: function(event, ui)
        {
            var multiPlaceholder = $(this).data('multi') ? true : false;

            if( multiPlaceholder || !$(this).hasClass('filled') ) {
                $(this).addClass('active-drop');
            }
        },
        out: function(event, ui)
        {
            $(this).removeClass('active-drop');
        }
    });

    function check() {
        var labels = $("#textContainer").find(".placeholder").length;
        var correct = 0;

        $("#textContainer").find(".placeholder").each(function() {
            var id = $(this).data('id');
            var labelId = $(this).data('label-id');

            if( id == labelId) {
                ++correct;
            }
        });

        if( correct == labels ) {
            showEndScreen(true);
        }
        else {
            showEndScreen(false);
        }
    };

    function showEndScreen(success) {
        var curtain = $('<div/>');
        var imageContainer = $('<div/>');
        var imgSrc;

        if( success ) {
            imgSrc = 'success.png';
        } else {
            imgSrc = 'fail.png';
        }

        imageContainer
        .html('<img src="images/'+imgSrc+'" alt="">')
        .addClass('imageContainer');

        imageContainer.click(function() {
            location.reload();
        });

        curtain
        .addClass('curtain')
        .append(imageContainer);

        $('body').prepend(curtain);

        $('#refresh').addClass('btn_overlay');
    };

    $("#refresh").on("click", function(e) {
        var confirmation = confirm('Czy na pewno chcesz zacząć od początku?');

        if( confirmation )
            location.reload();

        return confirmation;
    });
});