;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    text: "skrzydlak",
                    id: 1,
                    img: "img/game/liscie/klon.png",
                    img2: "img/game/owoce/owoc-klonu.png",
                    correctValue: "klon"
                },
                {
                    text: "żołędź",
                    id: 2,
                    img: "img/game/liscie/dab.png",
                    img2: "img/game/owoce/zoledz.png",
                    correctValue: "dąb"
                },
                {
                    text: "kasztan",
                    id: 3,
                    img: "img/game/liscie/kasztanowiec.png",
                    img2: "img/game/owoce/kasztany.png",
                    correctValue: "kasztanowiec"
                },
                {
                    text: "bukiew",
                    id: 4,
                    img: "img/game/liscie/buk.png",
                    img2: "img/game/owoce/bukiew.png",
                    correctValue: "buk"
                },
                {
                    text: "jarzębina",
                    id: 5,
                    img: "img/game/liscie/jarzebina.png",
                    img2: "img/game/owoce/jarzebina.png",
                    correctValue: "jarzębina"
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var $element = this.$element,
                _this = this,
                i = 0;

            $.each(this.settings.elements, function(key, obj)
            {
                $("<img/>")
                    .attr("src", obj.img)
                    .attr("data-id", obj.id)
                    .appendTo($element.find("table tbody tr").eq(i).attr("data-id", obj.id).find("td").eq(1));

                $("<div/>")
                    .addClass("element")
                    .addClass("draggable")
                    .addClass("has-text")
                    .addClass("draggable-fruit-name")
                    .text(obj.text)
                    .attr("data-id", obj.id)
                    .appendTo($element.find(".elements-top"));

                $("<div><img/></div>")
                    .addClass("element")
                    .addClass("draggable")
                    .addClass("has-image")
                    .addClass("draggable-fruit")
                    .find("img").attr("src", obj.img2).end()
                    .attr("data-id", obj.id)
                    .appendTo($element.find(".elements-bottom"));

                $element.find("table tbody tr").eq(i)
                    .find("td:first").append($("<input type='text'/>").attr("data-correct-value", obj.correctValue).addClass("first")).end()
                    .find("td:last").append($("<input type='text' class='hidden' />").attr("data-correct-value", obj.text)).end();

                i += 1;
            });

            $element.find("input").on("blur", function()
            {
                $(this).removeClass("answer-correct").removeClass("answer-incorrect");

                if($.trim($(this).val()))
                {
                    if($.trim($(this).val()).toLowerCase() === $(this).attr("data-correct-value").toLowerCase())
                    {
                        $(this).addClass("answer-correct");
                    }
                    else
                    {
                        $(this).addClass("answer-incorrect");
                    }
                }

                _this.check();
            });

            $element.find(".draggable").draggable({
                revert: "invalid",
                helper: "clone",
                appendTo: "#game",
                start: function()
                {
                    $(this).removeClass("answer-correct").removeClass("answer-incorrect");
                }
            });

            $element.find(".droppable.droppable-fruit").droppable({
                accept: ".draggable.draggable-fruit",
                drop: function(evt, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo($element.find(".elements-bottom"));
                    }

                    var $draggable = $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).appendTo($(this));

                    if($(this).closest("tr").attr("data-id") === $draggable.attr("data-id"))
                    {
                        $draggable.addClass("answer-correct");
                        $draggable.draggable({disabled: true});
                        $(this).droppable('disable');
                    }
                    else
                    {
                        $draggable.addClass("answer-incorrect");
                    }

                    $(this).removeClass("active-drop");

                    _this.check();
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });

            $element.find(".droppable.droppable-fruit-name").droppable({
                accept: ".draggable.draggable-fruit-name",
                drop: function(evt, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo($element.find(".elements-top"));
                    }

                    var $draggable = $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).prependTo($(this));

                    if($(this).closest("tr").attr("data-id") === $draggable.attr("data-id"))
                    {
                        $draggable.addClass("answer-correct");
                        $draggable.draggable({disabled: true});
                        $(this).droppable('disable');
                    }
                    else
                    {
                        $draggable.addClass("answer-incorrect");
                    }

                    $(this).removeClass("active-drop");

                    _this.check();
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });

            this.$element.find(".element").randomize();

            this.$element.find(".popup-instruction, .popup-overlay").show();

            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.step1 a").on("click", function()
            {
                _this.$element.find(".droppable input").removeClass("hidden");
                _this.$element.find(".popup.step1, .popup-overlay").hide();
                $(".popup-instruction2, .popup-overlay").show();
                $(".popup-instruction2 .start").on("click", function()
                {
                    $(".popup-instruction2, .popup-overlay").hide();
                    return false;
                });
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        check: function()
        {
            if(this.$element.find(".draggable.answer-correct").size() === this.settings.elements.length * 2
                && this.$element.find("input.first.answer-correct").size() === this.settings.elements.length
                && !this.firstStepAccomplished)
            {
                this.$element.find(".popup.step1, .popup-overlay").show();
                this.firstStepAccomplished = true;
            }
            else
            {
                if(this.firstStepAccomplished && this.$element.find("input:not(.first).answer-correct").size() === this.settings.elements.length)
                {
                    this.$element.find(".popup.step2, .popup-overlay").show();
                }
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);