;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    img: "img/elements/batony.png",
                    correctPosition: 1
                },
                {
                    img: "img/elements/biale-mieso.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/biale-pieczywo.png",
                    correctPosition: 3
                },
                {
                    img: "img/elements/cebula.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/ciemne-pieczywo.png",
                    correctPosition: 3
                },
                {
                    img: "img/elements/czerwone-mieso.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/hamburger.png",
                    correctPosition: 1
                },
                {
                    img: "img/elements/jablko.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/jajko.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/marchewki.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/ogorki.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/pizza.png",
                    correctPosition: 1
                },
                {
                    img: "img/elements/pomidory.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/ryba.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/salata.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/ser.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/slodkie-napoje.png",
                    correctPosition: 1
                },
                {
                    img: "img/elements/wedlina.png",
                    correctPosition: 2
                },
                {
                    img: "img/elements/winogron.png",
                    correctPosition: 4
                },
                {
                    img: "img/elements/woda.png",
                    correctPosition: 4
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                $element = $("<div><img alt/></div>").addClass("element").addClass("draggable");

            $.each(this.settings.elements, function(i, obj)
            {
                var $el = $element.clone()
                    .find("img").attr("src", obj.img).end()
                    .appendTo(_this.$element.find(".board"))
                    .attr("data-correct-position", obj.correctPosition);
            });

            this.$element.find(".droppable").droppable({
                accept: function($draggable)
                {
                    return $draggable.attr("data-correct-position") === $(this).attr("data-position");
                },
                drop: function(evt, ui)
                {
                    $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).appendTo($(this));
                    $(this).removeClass("active-drop");

                    _this.resize();
                    _this.check();
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });

            this.$element.find(".draggable").draggable({
                revert: "invalid",
                appendTo: this.$element,
                helper: "clone"
            });

            this.$element.find(".popup .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".element").randomize();

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        resize: function()
        {
            var containerHeight = this.$element.find(".board").height(),
                containerWidth = this.$element.find(".board").width(),
                marginBottom = 10,
                marginRight = 10,
                elementsPerRow = 1,
                elementSize = containerHeight,
                elementsCount = this.settings.elements.length,
                rows = elementsCount;

            while(rows * (elementSize + marginBottom) > containerHeight)
            {
                elementSize -= 5;
                elementsPerRow = Math.floor(containerWidth / (elementSize + marginRight));
                rows = Math.ceil(elementsCount / elementsPerRow);
            }

            this.$element.find(".element").each(function(index, item)
            {
                var $item = $(item);
                $item.width(elementSize).height(elementSize);
            });

            this.$element.find(".placeholder").each(function()
            {
                var nb = 0;
                $(this).find(".element").each(function()
                {
                    $(this).css("margin-top", Math.floor($(this).closest(".placeholder").height() / 2 - $(this).height() / 2) + "px");
                    $(this).css("left", (nb * 40) + "px");
                    nb += 1;
                });
            });

            var min = Math.min(this.$element.find(".pyramid-container").width(), this.$element.find(".pyramid-container").height());
            this.$element.find(".pyramid").width(min).height(min);

            this.$element.find(".placeholder").css("line-height", this.$element.find(".placeholder").height() + "px");
        },
        check: function()
        {
            var _this = this,
                correct = true,
                nbElements = this.$element.find(".element").size(),
                checkedNbElements = 0;

            this.$element.find(".placeholder .element").each(function()
            {
                var $this = $(this).removeClass("is-correct").removeClass("is-incorrect"),
                    position = $this.closest(".placeholder").attr("data-position");

                checkedNbElements += 1;
                if($this.attr("data-correct-position") !== position)
                {
                    correct = false;
                    return false;
                }
            });

            if(correct && checkedNbElements + 1 === nbElements)
            {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);