;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var shuffle = function shuffle(v)
    {
        for(var j, x, i = v.length; i; j = parseInt(Math.random() * i), x = v[--i], v[i] = v[j], v[j] = x);
        return v;
    };

    var View = function(game, opts)
    {
        var _this = this,
            opts;

        this.game = game;
        this.opts = opts;
        this.currentScreen = -1;
        this.$element = $(opts.element);

        this.render = function()
        {
            opts = shuffle(this.opts.elements.slice(0)).slice(0, 8);

            this.$element.screenKeyboard({
                keys: {
                    type: "num"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.hasClass("result-correct"))
                        {
                            return _this.$element.find("input:eq(1)")
                        }
                    }
                },
                height: "50%"
            }).on("screenKeyboard.on", function () {
                $('#game .wrapper').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('#game .wrapper').removeClass("screen-keyboard-on");
            });

            this.showNextScreen();
        };

        this.showNextScreen = function()
        {
            this.currentScreen += 1;

            if(this.currentScreen + 1 > opts.length)
            {
                return this.$element.find(".popup.popup-result, .popup-overlay").show();
            }

            this.$element.find(".wrapper .screen").remove();

            var $screen = this.$element.find("#template-screen").clone().removeAttr("id").find(" > *")
                .appendTo(this.$element.find(".wrapper"))
                .find(".left input").attr("data-correct-value", opts[this.currentScreen].lettersCount).end()
                .find(".right input").attr("data-correct-value", opts[this.currentScreen].phonesCount).end()
                .find("img").attr("src", opts[this.currentScreen].img).end()
                .find(".img-title").html(opts[this.currentScreen].title);

            if(this.$element.data("plugin_screenKeyboard").isKeyboardOn())
            {
                $screen.find("input:first").trigger("click");
            }
        };

        this.delegateEvents = function()
        {
            this.$element.on("keyup", "input", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                    value = $this.val() || "";

                if(value)
                {
                    if(value === $this.attr("data-correct-value"))
                    {
                        $this.addClass("result-correct");
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                }

                if($this.closest(".screen").find("input.result-correct").size() === 2)
                {
                    $this.closest(".screen").find(".next").show();
                }
                else
                {
                    $this.closest(".screen").find(".next").hide();
                }
            });

            this.$element.on("click", ".next", function()
            {
                _this.showNextScreen();
                if(_this.$element.data("plugin_screenKeyboard").isOn())
                {
                    _this.$element.find("input:first").trigger("click");
                }
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.resize = function()
        {
            this.$element.find(".photo-wrapper").css("line-height", this.$element.find(".photo-wrapper").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);