;
(function ($, window, document, undefined) {
    $('#refresh').on('click', function () {
        location.reload();
    });

    var pluginName = "game",
        defaults = {
            instructionDelay: 1000,
            equations: [
                {
                    equation: "2 + 10 =",
                    result: 12
                },
                {
                    equation: "20 – 6 =",
                    result: 14
                },
                {
                    equation: "11 + 9 =",
                    result: 20
                },
                {
                    equation: "2 - 1 =",
                    result: 1
                },
                {
                    equation: "2 + 3 =",
                    result: 5
                },
                {
                    equation: "2 + 2 =",
                    result: 4
                },
                {
                    equation: "7 + 8 =",
                    result: 15
                },
                {
                    equation: "9 – 7 =",
                    result: 2
                },
                {
                    equation: "9 + 6 =",
                    result: 15
                },
                {
                    equation: "12 + 6 =",
                    result: 18
                },
                {
                    equation: "16 – 6 =",
                    result: 10
                },
                {
                    equation: "2 + 1 =",
                    result: 3
                },
                {
                    equation: "3 + 5 =",
                    result: 8
                },
                {
                    equation: "10 + 10 =",
                    result: 20
                }
            ]
        };

    function Plugin(element, options) {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function () {
            this.currentEquation = 0;
            this.points = 0;
            this.stone = -1;

            var _this = this,
                intervalId,
                timer,
                $equation = $("<p><span class='equation'></span><input type='text' /></p>").addClass("equation-wrapper"),
                fnOnKeyUpEquation = function fnOnKeyUpEquation(e) {
                    var $this = $(this).removeClass('result-incorrect'),
                        value = $.trim($this.val()),
                        key = e.keyCode ? e.keyCode : e.charCode;

                    if (key == 13) {
                        if (value === $this.attr("data-correct-value")) {
                            _this.points += 1;
                            _this.stone += 1;
                        }
                        _this.showNextEquation(value === $this.attr("data-correct-value"));
                    }
                },
                currentInstruction = 0,
                fnNextInstruction = function fnNextInstruction() {
                    currentInstruction += 1;
                    if (_this.$element.find(".instruction-" + currentInstruction).size()) {
                        _this.$element.find(".instruction-" + (currentInstruction - 1)).fadeOut(1000);
                        _this.$element.find(".instruction-" + currentInstruction).fadeIn(1000);
                        $('#start_game').on('click', function () {
                            fnNextInstruction();
                            return false;
                        });
                    }
                    else {
                        _this.$element.find(".instruction").hide();
                        _this.$element.find(".instruction.has-equations").show();
                        _this.startGame();
                    }
                };

            $.each(this.settings.equations, function (key, eq) {
                var $eq = $equation.clone()
                    .find(".equation").text(eq.equation).end()
                    .find("input").attr("data-correct-value", eq.result).on("keydown", fnOnKeyUpEquation).end()
                    .appendTo(_this.$element.find(".instruction .equations-wrapper"));
            });
            setTimeout(function () {
                fnNextInstruction();
            }, 7000);

        },
        startTimer: function () {
            this.timer = 0;
            var _minutes = 0;
            var _seconds = 0;
            $('#timer').html(((_minutes.toString().length === 1) ? '0' + _minutes.toString() : _minutes.toString()) + ":" + ((_seconds.toString().length === 1) ? '0' + _seconds.toString() : _seconds.toString()));
            var _this = this;
            this.intervalId = setInterval(function () {
                _this.timer++;
                var _minutes = Math.floor(_this.timer / 60);
                var _seconds = _this.timer - _minutes * 60;
                $('#timer').html(((_minutes.toString().length === 1) ? '0' + _minutes.toString() : _minutes.toString()) + ":" + ((_seconds.toString().length === 1) ? '0' + _seconds.toString() : _seconds.toString()));
            }, 1000);

        },
        startGame: function () {
            this.$element.find(".instruction .equations-wrapper").addClass("active").find(".equation-wrapper:first").addClass("active").find("input").trigger("focus");
            this.startTimer();

        },
        showNextEquation: function (animateStone) {
            var $currentEquation = this.$element.find(".instruction .equation-wrapper.active"),
                $nextEquation = $currentEquation.next();

            $currentEquation.fadeOut("fast", function () {
                $currentEquation.removeClass("active");
                $nextEquation.fadeIn("fast", function () {
                    $nextEquation.addClass("active").find("input").trigger("focus");
                });
            });

            if (animateStone) {
                this.$element.find(".stone").eq(this.stone).addClass("animated").show();
            }
            this.currentEquation += 1;
            this.check();
        },
        check: function () {
            var _this = this;

            if (this.points === 10 || this.currentEquation === this.settings.equations.length) {
                clearInterval(this.intervalId);
                var _minutes = Math.floor(_this.timer / 60);
                var _seconds = _this.timer - _minutes * 60;
                var timer = ((_minutes.toString().length === 1) ? '0' + _minutes.toString() : _minutes.toString()) + ":" + ((_seconds.toString().length === 1) ? '0' + _seconds.toString() : _seconds.toString());
                $('.timer_result').html(timer);
                $('.points_result').html(this.points + '/' + this.currentEquation);
            }

            if (this.points === 10) {
                _this.$element.find(".instruction").fadeOut("fast", function () {
                    setTimeout(function () {
                        _this.$element.find("#car").addClass("animated");
                        setTimeout(function () {
                            _this.$element.find(".popup.popup-success, .popup-overlay").show();
                            _this.$element.find(".instruction").hide();
                        }, 5000);
                    }, 2000);
                });
            }
            if (this.currentEquation === this.settings.equations.length) {
                this.$element.find(".popup.popup-failed, .popup-overlay").show();
                this.$element.find(".instruction").hide();
            }
        }
    });
    $.fn.randomize = function (selector) {
        (selector ? this.find(selector) : this).parent().each(function () {
            $(this).children(selector).sort(function () {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function (options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);