var phonecatApp = angular.module('games', []);

phonecatApp.controller('square', function ($scope) {
    var colors = ['#FF00FF', '#FFFF00', '#00FFFF', '#FF0000', '#0000FF', '#00FF00'];
    var pos_figures = ['square', 'feather', 'shell', 'stick', 'triangle', 'small_triangle', 'ball', 'up_small_triangle', 'up_triangle', 'box', 'box', 'small_square', 'small_square', 'small_square', 'small_ball'];
    var left_width = 0;
    var top = 0;
    var current_eq = 0;
    var current_figure = 0;
    var good_answers = 0;
    var is_started = false;
    var $eq_input = $('input#eq_result');
    var equations = [{eq: '30:5', res: '6'}, {eq: '24:4', res: '6'}, {eq: '96-90', res: '6'}, {
        eq: '12:2', res: '6'}, {eq: '30-20', res: '10'}, {eq: '40-30', res: '10'},
        {eq: '50-40', res: '10'}, {eq: '56-50', res: '6'}, {eq: '5+5', res: '10'}, {eq: '70-60', res: '10'},
        {eq: '26-20', res: '6'}, {eq: '35-25', res: '10'}, {eq: '100-90', res: '10'}, {eq: '30:3', res: '10'}, {eq: '2x3', res: '6'}];
    var eqs_count = equations.length;
    equations = shuffle(equations);

    init();

    function init() {
        setEq(equations[current_eq++]);
        $eq_input.val('');
        $('#send').on('click', function () {
            var user_result = $eq_input.val();
            $eq_input.val('');
            if (user_result == $eq_input.data('result')) {
                addElement(current_figure++);
                good_answers++;
                $('span#replay').html('Poprawna odpowiedź').addClass('approved').removeClass('not-approved')
                    .show().delay(1000).fadeOut(1000);
            } else {
                $('span#replay').html('Błędna odpowiedź').addClass('not-approved').removeClass('approved')
                    .show().delay(1000).fadeOut(1000);
            }
            if (current_eq == eqs_count) {
                if (good_answers != 0) {
                    $('#equation_container').html('Ułóż dom ze zdobytych elementów.');
                } else {
                    $('#equation_container').html('Spróbuj jeszcze raz!');
                }
                is_started = true;
                startBuilding();
            } else {
                setEq(equations[current_eq++]);
            }
        });

    }

    function setEq(eq) {
        $('span#equation').html(eq.eq);
        $('input#eq_result').data('result', eq.res);
    }


    function startBuilding() {

        $("div.draggable").draggable(
            {
                containment: "#workplace",
                scroll: false,
                snap: ".draggable",
                snapMode: "both",
                snapTolerance: 10,
                stack: "div.draggable",
                start: function () {
                },
                drag: function () {
                },
                stop: function () {
                }
            });
    }

    function addElement(i) {
        $("<div>")
            .addClass("draggable " + pos_figures[i])
            .attr("id", "box" + (i + 1))
            .appendTo("#workplace");

        if (left_width == 0) left_width = $("#box" + (i + 1)).position().left + 10;
        if (top == 0) top = $("#box" + (i + 1)).position().top + 10;

        if ((left_width + 10) > 800) {
            left_width = $("#box" + (i + 1)).position().left + 10;
            top += 300;
        }

        $("#box" + (i + 1))
            .css('top', top + 'px')
            .css('left', left_width + 'px');

        left_width += $("#box" + (i + 1)).outerWidth() + 10;

        var color = colors[Math.floor((Math.random() * colors.length))];

        if (pos_figures[i] == 'triangle' || pos_figures[i] == 'small_triangle') {
            $("#box" + (i + 1)).css('border-bottom-color', color);
        }
        else if (pos_figures[i] == 'up_triangle' || pos_figures[i] == 'up_small_triangle') {
            $("#box" + (i + 1)).css('border-top-color', color);
        }
        else {
            $("#box" + (i + 1)).css('background-color', color);
        }

    }

    function shuffle(array) {
        var currentIndex = array.length, temporaryValue, randomIndex;
        while (0 !== currentIndex) {
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;

            temporaryValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = temporaryValue;
        }

        return array;
    }


});