;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        var _this = this;

        this.render = function()
        {
            this.maze = new Maze.Maze(10, 10);
            this.maze.generate();
            this.maze.setRenderer(new Maze.RendererCanvas(this.maze, {
                canvasID: "canvas",
                mazeLineWidth: 4,
                mazeLineColor: ["#46cc45", "#69ec68"]
            })).render();

            this.mazeGame = new Maze.Game(this.maze, {
                playerImg: "img/maze-player.png",
                onFinish: function()
                {
                    _this.$element.find(".popup.popup-result-a, .popup-overlay").show();
                }
            });
            this.mazeGame.start();

            this.$element.find(".popup.popup-instruction-a .button-start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction-a, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.popup-result-a .button-next").on("click", function()
            {
                _this.$element.find(".popup.popup-result-a, .popup-overlay").hide();
                _this.$element.find(".exercise-a").hide();
                _this.$element.find(".exercise-b").show();
                _this.$element.find(".popup.popup-instruction-b").show();
                _this.resize();
                return false;
            });

            this.$element.find(".popup.popup-instruction-b .button-start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction-b, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".vase-element").draggable({
                revert: "invalid",
                helper: "clone"
            }).randomize();

            this.$element.find(".vase-placeholder, .vase-elements").droppable({
                accept: ".vase-element",
                drop: function(e, ui)
                {
                    var $this = $(this).removeClass("active-drop");

                    if($this.is(".vase-placeholder") && $this.find(".vase-element").size())
                    {
                        $this.find(".vase-element").appendTo(_this.$element.find(".vase-elements"));
                    }

                    $(ui.draggable).detach().appendTo($this);

                    if(_this.checkExercise2())
                    {
                        _this.endGame();
                    }
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".popup.popup-instruction-a, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            $(document).keydown(function(e)
            {
                if(e.which === 38)
                {
                    _this.mazeGame.move("up");
                    e.preventDefault();
                }
                if(e.which === 40)
                {
                    _this.mazeGame.move("down");
                    e.preventDefault();
                }
                if(e.which === 37)
                {
                    _this.mazeGame.move("left");
                    e.preventDefault();
                }
                if(e.which === 39)
                {
                    _this.mazeGame.move("right");
                    e.preventDefault();
                }
                return false;
            });

            this.$element.find(".arrow").on("click", function()
            {
                var $this = $(this),
                    direction;

                if($this.is(".arrow-left"))
                {
                    direction = "left";
                }
                if($this.is(".arrow-right"))
                {
                    direction = "right";
                }
                if($this.is(".arrow-up"))
                {
                    direction = "up";
                }
                if($this.is(".arrow-down"))
                {
                    direction = "down";
                }
                _this.mazeGame.move(direction);
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.resize = function()
        {
            var _this = this;

            var height = this.$element.find(".exercise-a").height();
            this.$element.find(".exercise-a").css("line-height", height + "px");

            var width = this.$element.find(".exercise-b .vase-contour-container").width();
            var ratio = 759 / 768;

            this.$element.find(".exercise-b .vase-contour, .exercise-b .vase-elements").width(width).height(width / ratio);

            this.$element.find(".vase-placeholder").each(function()
            {
                var $this = $(this),
                    $element = _this.$element.find(".vase-element[data-element-id='" + $this.attr("data-element-id") + "']");

                $this.height($element.find("img").height());
            });

            height = this.$element.find(".vase-elements-container").height();
            this.$element.find(".vase-elements-container, .vase-contour-container").css("line-height", height + "px");
        };

        this.checkExercise2 = function()
        {
            var _this = this,
                result = true;

            if(this.$element.find(".vase-contour .vase-element").size() === this.$element.find(".vase-element").size() - 1)
            {
                this.$element.find(".vase-contour .vase-element").each(function(i)
                {
                    if(i + 1 != $(this).attr("data-element-id"))
                    {
                        result = false;
                        return false;
                    }
                });
                return result;
            }
            return false;
        };

        this.endGame = function()
        {
            this.$element.find(".popup.popup-result, .popup-overlay").show();
        }
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);