;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.currentTool = null;
        this.currentProduct = null;

        this.result = {};

        this.render = function()
        {

        };

        this.delegateEvents = function()
        {
            this.$element.find(".tool").on("click", function()
            {
                _this.$element.find(".tmp-container .tool").remove();
                _this.$element.find(".tmp-container .product").remove();
                _this.$element.find(".tmp-container .combined-element").hide();
                _this.currentProduct = null;
                _this.combinedElement = null;
                _this.$element.find(".is-active").removeClass("is-active");
                _this.currentTool = $(this).addClass("is-active");
                return false;
            });

            this.$element.find(".product").on("click", function()
            {
                if(!_this.currentTool)
                {
                    _this.game.playErrorSound();
                    return false;
                }
                if(_this.currentTool.attr("data-tool-id") !== $(this).attr("data-accepted-tool"))
                {
                    _this.game.playErrorSound();
                    return false;
                }
                _this.$element.find(".tmp-container .combined-element").hide();
                _this.$element.find(".product.is-active").removeClass("is-active");
                _this.currentProduct = $(this).addClass("is-active");
                _this.combinedElement = _this.$element.find("[data-id='" + (_this.currentTool.attr("data-tool-id") + "-" + _this.currentProduct.attr("data-product-id")) + "']").show();
                return false;
            });

            _this.$element.find(".bowl").on("mouseover", function()
            {
                if(_this.combinedElement)
                {
                    $(this).addClass("is-zoomed");
                }
            }).on("mouseout", function()
            {
                $(this).removeClass("is-zoomed");
            }).on("click", function()
            {
                var $this = $(this);
                if(!_this.combinedElement)
                {
                    _this.game.playErrorSound();
                    return false;
                }
                _this.$element.find(".is-active").removeClass("is-active");
                _this.$element.find(".tmp-container .combined-element").hide();
                if(!_this.result[_this.combinedElement.attr("data-id")])
                {
                    _this.result[_this.combinedElement.attr("data-id")] = 0;
                }
                _this.result[_this.combinedElement.attr("data-id")] += 1;

                var count = parseInt(_this.currentProduct.find(".count").text()) + 1;
                _this.currentProduct.find(".count").text(count);

                _this.combinedElement = null;
                _this.$element.find(".tmp-container .tool").remove();
                _this.currentTool = null;
                _this.check();
                if(_this.game.isTouchSupported())
                {
                    $this.addClass("is-zoomed");
                    setTimeout(function()
                    {
                        $this.removeClass("is-zoomed");
                    }, 1000);
                }
            });

            $("body").on("mousemove", function(e)
            {
                if(_this.currentTool && !_this.game.isTouchSupported())
                {
                    var $currentTool = _this.currentTool;
                    if(_this.$element.find(".tmp-container").find("[data-tool-id='" + $currentTool.attr("data-tool-id") + "']").size() === 0)
                    {
                        $currentTool.clone().appendTo(_this.$element.find(".tmp-container")).css({
                            left: e.clientX + 10,
                            top: e.clientY + 10
                        });
                    }
                    else
                    {
                        _this.$element.find(".tmp-container").find("[data-tool-id='" + $currentTool.attr("data-tool-id") + "']").css({
                            left: e.clientX + 10,
                            top: e.clientY + 10
                        });
                    }
                }
                if(_this.combinedElement && !_this.game.isTouchSupported())
                {
                    _this.$element.find(".tmp-container .tool").remove();

                    var $combinedElement = _this.combinedElement;
                    $combinedElement.css({
                        left: e.clientX + 10,
                        top: e.clientY + 10
                    });
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.check = function()
        {
            var result = this.result;
            if(result["glass-flour"] === 6 && result["hand-apple"] === 6 && result["hand-egg"] === 4)
            {
                if(result["spoon-butter"] === 14 && result["spoon-milk"] === 8 && result["spoon-sugar"] === 12)
                {
                    this.$element.find(".popup.popup-result, .popup-overlay").show();
                }
            }

            if(result["glass-flour"] > 6 || result["hand-apple"] > 6 || result["hand-egg"] > 4 || result["spoon-butter"] > 14 && result["spoon-milk"] > 8 && result["spoon-sugar"] > 12)
            {
                this.$element.find(".popup.popup-result-failed, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".instruction").css("line-height", this.$element.find(".instruction").height() + "px");

            var min = Math.min(this.$element.find(".tools").width() * 0.15, this.$element.find(".tools").height());
            this.$element.find(".tool, .combined-element").width(min).height(min);

            var ratio = 1024 / $(window).width() + 0.3;
            $("body").css("font-size", (22 / ratio) + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        var audio = document.createElement('audio'),
            supportAudio = !!(audio.canPlayType && audio.canPlayType('audio/mpeg;').replace(/no/, '')),
            supportTouch = 'ontouchstart' in document.documentElement;

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };

        this.playErrorSound = function()
        {
            if(supportAudio)
            {
                audio = new Audio(this.opts.errorAudio);
                audio.play();
            }
        };

        this.isTouchSupported = function()
        {
            return supportTouch;
        };
    };

    window.Game = Game;

})(jQuery, window, document);