/*
	=================================================================
	MAIN JAVASCRIPT
	=================================================================
	@project         Gra 16
	@date            2014-07-25
	@author          Piotrek Wojciechowski (piotrekwojciechowski.com)
	@company         Smultron
	=================================================================
*/

/*global $, document, window, setInterval, clearInterval, setTimeout, clearTimeout, google*/

// @prepros-prepend "plugins.js"

(function ($) {

window.G = {
	/*
	 * Add class related to screen proportions, set the game container to have rectangular proportions
	 */
	manageOrientation: function () {
		var bdy = $('body'),
			vp = $(window),
			boardWrap = $('.boardWrap');

		function doIt () {
			if (vp.width() > vp.height()) {
				bdy.attr('class', 'horizontal');
				boardWrap.removeAttr('style');
				boardWrap.css({
					width: vp.height() * 0.9,
					'margin-left': -0.5 * vp.height() * 0.9
				});
			} else {
				bdy.attr('class', 'vertical');
				boardWrap.removeAttr('style');
				boardWrap.css({
					height: vp.width(),
					'margin-top': -0.5 * vp.width()
				});
			}
		}
		doIt();

		vp.on('resize orientationchange', doIt);
	},

	/*
	 * Run player on click, set reload event
	 */
	manageInteraction: function () {
		var self = this;
		var reload = $('.reload');

		self.items.on('click', function () {
			var me = $(this);
				thisID = me.data('id');


			if (me.hasClass('disabled')) {
				return false;
			} else {

				// play the sound
				if (self.isPieceofpain) {
					var player = document.getElementById('a' + thisID);
					player.play();
				} else {
					var player = document.getElementById('a' + thisID);
					player.currentTime = 0;
					player.play();
				}

				player.addEventListener('ended', function () {
					player.currentTime = 0;
					player.pause();
					me.addClass('disabled');
				});
			}
		});

		reload.on('click', function () {
			self.items.removeClass('disabled');
		});
	},

	/*
	 * Items animation on page load
	 */
	showItems: function () {
		var self = this;
		var counter = 0;

		self.items.each(function () {
			var me = $(this);
			setTimeout(function () {
				me.addClass('loaded');
			}, 250 * counter);
			counter++;
		});
	},

	/*
	 * Run
	 */
	init: function () {
		var self = this;

		self.isPieceofpain = false;
		if (navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i)) {
		    self.isPieceofpain = true;
		}

		this.items = $('.item');
		this.manageOrientation();
		this.manageInteraction();

		$(window).on('load', function () {
			self.showItems();
		});
	}
};


$(document).ready(function() {
	G.init();
});

})(jQuery);


