/*
	=================================================================
	MAIN JAVASCRIPT
	=================================================================
	@project         Gra 16
	@date            2014-07-25
	@author          Piotrek Wojciechowski (piotrekwojciechowski.com)
	@company         Smultron
	=================================================================
*/

/*global $, document, window, setInterval, clearInterval, setTimeout, clearTimeout, google*/

// @prepros-prepend "plugins.js"

(function ($) {

window.G = {
	/*
	 * Add class related to screen proportions, set the game container to have rectangular proportions
	 */
	manageOrientation: function () {
		var bdy = $('body'),
			vp = $(window),
			boardWrap = $('.boardWrap');

		function doIt () {
			if (vp.width() > vp.height()) {
				bdy.attr('class', 'horizontal');
				boardWrap.removeAttr('style');
				boardWrap.css({
					width: vp.height() * 0.9,
					'margin-left': -0.5 * vp.height() * 0.9
				});
			} else {
				bdy.attr('class', 'vertical');
				boardWrap.removeAttr('style');
				boardWrap.css({
					height: vp.width(),
					'margin-top': -0.5 * vp.width()
				});
			}
		}
		doIt();

		vp.on('resize orientationchange', doIt);
	},

	/*
	 * Run player on click, set reload event
	 */
	manageInteraction: function () {
		var self = this;
		var reload = $('.reload');

		self.sounds.on('click', function () {
			var me = $(this);

			self.soundID = me.data('id');

			if (me.hasClass('disabled') || me.hasClass('solved')) {
				return false;
			} else {

				// play the sound
				if (self.isPieceofpain) {
					var player = document.getElementById('a' + self.soundID);
					player.play();
				} else {
					var player = document.getElementById('a' + self.soundID);
					player.currentTime = 0;
					player.play();
				}

				// disable cards and other sounds when playing
				self.items.addClass('disabled');
				self.sounds.addClass('disabled');
				me.removeClass('disabled');

				// when sound finished playing
				player.addEventListener('ended', function () {
					player.currentTime = 0;
					player.pause();

					//disable all sounds
					self.sounds.addClass('disabled');

					//enable cards
					self.items.removeClass('disabled');
				});
			}
		});

		self.items.on('click', function () {

			var me = $(this);

			self.cardID = me.data('id');

			if (me.hasClass('disabled') || me.hasClass('solved') ) {
				return false;
			} else {
				self.items.not(me).addClass('disabled');
				me.addClass('flipped');

				if (self.soundID === self.cardID) {
					me.addClass('solved');
					self.solved += 1;

					self.sounds.filter('[data-id=' + self.soundID + ']').addClass('solved');

					if (self.solved == self.itemsCount) {
						self.welldone();
					} else {
						self.resetBoard();
					}
				} else {
					setTimeout(function () {
						self.resetBoard();
					}, 1000);
				}
			}
		});

		reload.on('click', function () {
			window.location.reload();
		});
	},

	resetBoard: function () {
		var self = this;

		self.sounds.removeClass('disabled');
		self.items.each(function () {
			var me = $(this);

			if (me.hasClass('solved')) {
				me.removeClass('disabled');
			} else {
				me.addClass('disabled').removeClass('flipped');
			}
		});
	},

	welldone: function () {
		var self = this;

		if (self.isPieceofpain) {
			var player = document.getElementById('welldone');
			player.play()
		} else {
			var player = document.getElementById('welldone');
			player.currentTime = 0;
			player.play();
		}

		// play the sound
		self.items.addClass('disabled');
		self.sounds.addClass('disabled').removeClass('flipped').removeClass('solved');
	},

	/*
	 * Items animation on page load
	 */
	showItems: function () {
		var self = this;
		var counter = 0;

		self.randomizeItems();

		self.items.each(function () {
			var me = $(this);
			setTimeout(function () {
				me.addClass('loaded');
			}, 250 * counter);
			counter++;
		});

		setTimeout(function () {
			self.items.addClass('disabled');
		}, 1000);
	},

	randomizeItems: function () {
		var self = this;

		self.items.sort(function() {
			return (Math.round(Math.random())-0.5);
		});

		$('.item').remove();

		for (var i=0; i < self.items.length; i++) {
			$('.items').append(self.items[i]);
		}

		self.items = $('.item');
		self.manageInteraction();
	},

	/*
	 * Run
	 */
	init: function () {
		var self = this;

		self.isPieceofpain = false;
		if (navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i)) {
		    self.isPieceofpain = true;
		}

		this.items = $('.item');
		this.sounds = $('.sounds li');
		this.manageOrientation();
		this.player;

		this.soundID = 0;
		this.cardID = 0;
		this.itemsCount = this.items.length;
		this.solved = 0;

		$(window).on('load', function () {
			$('#loader').hide();
			$('.layout').addClass('loaded');
			self.showItems();
		});
	}
};


$(document).ready(function() {
	G.init();
});

})(jQuery);


