$(document).ready(function(){
	
	var birds = [
		{name:'bocian',country:'afryka',alternate:'bocian'},
		{name:'jaskolka',country:'afryka',alternate:'jaskółka'},
		{name:'slowik',country:'afryka',alternate:'słowik'},
		{name:'kukulka',country:'afryka',alternate:'kukułka'},
		{name:'wrobel',country:'polska',alternate:'wróbel'},
		{name:'sikorka',country:'polska',alternate:'sikorka'},
		{name:'puszczyk',country:'polska',alternate:'puszczyk'},
		{name:'myszolow',country:'afryka',alternate:'myszołów'},
		{name:'gawron',country:'polska',alternate:'gawron'},
	];
	
	var maps = [
		{name:'polska'},
		{name:'afryka'}
	];
	
	function loadElements(){
		birds.sort(function() { return 0.5 - Math.random() });
		for(var i = 0; i < birds.length; i++){
			var img = '<img alt="'+birds[i]['alternate']+'" src="files/img/'+birds[i]['name']+'.png">';
			$(img).appendTo('#draggable').data({'parent':'','country':birds[i]['country']}).draggable({
				containment: '#page',
				stack: '#draggable img',
				revert: false
			}).css({'left':3});
		}
		$('<div id="input"><input type="button" value="ROZWIĄŻ" /></div>').appendTo('#draggable');
		for(var i = 0; i < maps.length; i++){
			$('#map'+i).data('country',maps[i]['name']).droppable({
				accept: '#draggable img',
				drop: dropBird
			});
		}
		$('#draggable').droppable({
			accept: '#draggable img',
			hoverClass: 'hovered',
			drop: dropBirdReset
		});
	}
	
	function dropBirdReset(event,ui){
		ui.draggable.data('parent','');
		$('#input').css({'display':'none'});
	}
	
	function dropBird(event,ui){
		
		ui.draggable.data('parent', $(this).data('country'));
		
		var score = 0;
		var badScore = 0;
		
		for(var i = 0; i < birds.length; i++){
			
			var parent = $('#draggable img:eq('+i+')').data('parent');
			var country = $('#draggable img:eq('+i+')').data('country');
			
			if(parent === country){
				score++;
			}
			else{
				if(parent !== '' && parent !== country){
					badScore++;
				}
			}
		}
		
		if(score+badScore == birds.length){
			$('#input').css({'display':'block'});
		}
		
	}
	
	function init(){
		loadElements();
		$('#input').click(function(){
			
			var score = 0;
			var badScore = 0;
			
			for(var i = 0; i < birds.length; i++){
				
				var parent = $('#draggable img:eq('+i+')').data('parent');
				var country = $('#draggable img:eq('+i+')').data('country');
				
				if(parent === country){
					score++;
				}
				
			}
			
			if(score == birds.length){
				$('#input').css({'display':'none'});
				$('#message-content-text').html('Dobra robota !');
				$("#cover").css({'opacity':'0.0'}).fadeIn("slow");
				$("#message").fadeIn("slow");
			}
			else{
				$("#cover").css({'opacity':'0.6'}).fadeIn("slow");
				$("#question").fadeIn("slow",function(){
					$("#question").fadeOut("slow");
					$("#cover").fadeOut("slow");
				});
			}
			
		});
	}
	
	$(init);
	
});