var app = 
{
    configuration:
    {
        server:
        {
            ip: 'passwordit.pl',
            path: '/old/'
        },
        game:
        {
            cards: [
                {id: 1, img: 'img/1.png', word: 'Narciarstwo<br/>alpejskie'},
                {id: 2, img: 'img/2.png', word: 'Saneczkarstwo'},
                {id: 3, img: 'img/3.png', word: 'Hokej<br/>na lodzie'},
                {id: 4, img: 'img/4.png', word: 'Skoki<br/>narciarskie'},
                {id: 5, img: 'img/5.png', word: 'Łyżwiarstwo<br/>figurowe'},
                {id: 6, img: 'img/6.png', word: 'Łyżwiarstwo<br/>szybkie'},
                {id: 7, img: 'img/7.png', word: 'Bobsleje'}
            ],
            maxScore: 100,
            cardsTimeout: 2
        }
    },
    
    game: {
        cards: [],
        moves: 0,
        flipCard: function flipCard(elmt) {
            $(document).off();

            if($('.flipped').length < 2 && $(elmt).hasClass('active')) {
                $(elmt).addClass('flipped');
            }
            
            var _elmts = $('.flipped');
            if($('.flipped').length === 2) {
                if($(_elmts[0]).data('card-id') === $(_elmts[1]).data('card-id')) {
                    $(_elmts[0]).removeClass('active').removeClass('flipped').addClass('success').removeAttr('tabindex');
                    $(_elmts[1]).removeClass('active').removeClass('flipped').addClass('success').removeAttr('tabindex');
                } else {
                    setTimeout(function(){
                        $('.highlighted').removeClass('highlighted');
                        bindEvents();
                        $('.flipped').removeClass('flipped');
                    }, app.configuration.game.cardsTimeout*1000);
                }
            }
            
            if($('.card.active').length === 0) {
                $('#score p span#game_moves').html(app.game.moves);

				$('.screen').hide();
				$('#score').slideToggle();
                return;
            }

            if($('.flipped').length < 2) {
                app.game.moves++;
                bindEvents();
            }
        }
    },
                
    init: function()
	{
        this.showScreen('board');
    },
    showScreen: function(activeScreenId) {
		$('.screen').hide();
        $('#' + activeScreenId).show();
        if(activeScreenId === 'board') {
            this.generateBoard();
        }
        $('[tabindex]').attr('tabindex', -1);
        $('#' + activeScreenId + ' [tabindex]').attr('tabindex', 0);
        return;
    },
    generateBoard: function(_mode) {
        var _cardsCount = this.configuration.game.cards.length;
        for(var i = 0; i < _cardsCount; i++) {
            this.game.cards.push({cardId: app.configuration.game.cards[i].id, img: app.configuration.game.cards[i].img});
            this.game.cards.push({cardId: app.configuration.game.cards[i].id, word: app.configuration.game.cards[i].word});
        }
        this.game.cards.shuffle();

        $.each(app.game.cards, function(index, item) {
            if(item.hasOwnProperty('img')) {
                $("#board").append('<div class="card active" tabindex=0 data-card-id="' + item.cardId + '"><img src="' + item.img + '" /></div>');
            } else if(item.hasOwnProperty('word')) {
                $("#board").append('<div class="card active" tabindex=0 data-card-id="' + item.cardId + '"><span>' + item.word + '</span></div>');
            } else {
                console.log('error finding property');
            }
        });
        
        var _inRow = 4;
        var _elmnts = $('div.card');
        for(var i=0; i < _elmnts.length; i+=_inRow) {
            _elmnts.filter(':eq(' + i + '),:lt(' + (i+_inRow) + '):gt('+i+')').wrapAll('<div class="rowWrapper clearfix"/>');
        }
        $('div.rowWrapper:last').after('<div class="clearfix" />');
    }
};

$(document).ready(function() {
    app.init();
    bindEvents();
    
    $('*[tabindex=0]').on('blur', function(){
        $('.highlighted').removeClass('highlighted');
    }).on('focus', function(){
        $('.highlighted').removeClass('highlighted');
        $(this).addClass('highlighted');
    });
});

function bindEvents() {
    $(document).on('focusin', '.card', function() {
        $(this).first().addClass('highlighted');
    });

    $(document).on('focusout', '.card', function() {
        $(this).removeClass('highlighted');
    });

    $(document).on('click', '.card', function() {
        app.game.flipCard($(this));
    });

    $(document).on('keyup', '.card', function(e) {
        if(e.keyCode === 13) {
            app.game.flipCard($(this));
            return false;
        }
    });
}

//Fisher-Yates Shuffle Modern Algorithm
Array.prototype.shuffle = function() {
    var i = this.length, j, temp;
    while(i-- > 0) {
        j = Math.floor(Math.random() * (i+1));
        temp = this[j];
        this[j] = this[i];
        this[i] = temp;
    }
    return true;
}