var class_draggable = '.fungus';
var class_droppable = '#basket';

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {

            if (ui.draggable.data('element-id') != 'ok') {
                ui.draggable.data('dropped', false);
                ui.draggable.addClass('notapproved');
                setTimeout(function(){
                    ui.draggable.removeClass('notapproved');
                }, 1000);
                return false;
            }
            ui.draggable.data('dropped', true);

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');

            if (ui.draggable.data('element-id') == 'ok') {
                ui.draggable.removeClass('notapproved').addClass('approved');
            }
            if($(this).find(class_draggable).length == 5){
                $('.end-popup').show();
            }
        }
    });

    $('#fungus-box').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }
        return false;
    });


});

