var class_draggable = '.caption';
var class_droppable = '.image-caption';
var stage_id = 1;

function loadNextLevel(){
    stage_id++;
    $('#stage_1, #stage_2, #stage_3').hide();
    switch (stage_id){
        case 2:
            $('.picture').show();
            $('#stage_2').show();
            break;
        case 3:
            $('.word').show();
            $('#stage_3').show();
            break;
        case 4:
            window.location.replace("kolorowanka/index.html");
            break;
    }
}

function testOrder() {
    var allok = true;
    var check_class = '';
    switch (stage_id){
        case 1:
            check_class = '.date-box';
            break;
        case 2:
            check_class = '.picture';
            break;
        case 3:
            check_class = '.word';
            break;
    }

    $(check_class+'.image-caption').each(function () {
        if ($(this).find('.caption').length == 0 || $(this).data('element-id') != $(this).find('.caption').data('element-id')) {
            allok = false;
        }
    });

    if (allok) {
        switch (stage_id){
            case 1:
                check_class = '.picture';
                $('#stage-info').html('Przeciągnij obrazki i upuść w odpowiednim miejscu.');
                break;
            case 2:
                check_class = '.word';
                $('#stage-info').html('Dopasuj podpisy w języku angielskim do przedstawionych pór roku.');
                break;
            case 3:
                $('#stage-info').html('Brawo! Przejdź do następnego etapu.');
                break;
        }
        $('#nextstage-popup').show();
    }

}

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);


            var prev_element = $(this).children(class_draggable);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            prev_element.each(function () {
                $(this).detach().appendTo('#stage_' + stage_id).removeClass('notapproved');
            });

            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();
        }
    });

    $('.draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();

    $('.picture, .word').hide();
    $('#start-game').on('click', function () {
        $('#next-stage').on('click', function () {
            loadNextLevel();
            $('#nextstage-popup').hide();
            return false;
        });

        $('#nextstage-popup').css('visibility' ,'visible').hide();

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('#counter_box').html('<span id="counter">3</span>');


        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('#startgame-popup').hide();
                clearInterval(first_counter);
            }
        }


        return false;
    });

    
});
