function test() {
    var $word_1 = $('#word-1');
    var $word_2 = $('#word-2');
    if($word_1.data('card-id') == $word_2.data('card-id')){
        $word_1.addClass('correct');
        $word_2.addClass('correct');

        $word_1.removeClass('uncovered').attr('id', '');
        $word_2.removeClass('uncovered').attr('id', '');
    }else{
        setTimeout(function(){
            $word_1.removeClass('uncovered').attr('id', '');
            $word_2.removeClass('uncovered').attr('id', '');
        }, 1000);
    }

    if($('#board').find('.correct').length  == $('#board').find('.card').length){
        $('#nextstage-popup').show();
    }
}

function nextStage(){
    window.location.replace("kolorowanka/index.html");
}

function resize(){
    var height = $(window).height()/4 - 20;
    $('.card').height(height).width(height);
}

$(document).ready(function () {
    resize();

    $('#nextstage-popup').on('click', function(){
        nextStage();
        return false;
    }).css('visibility', 'visible').hide();

    $('.front').on('click', function () {
        var uncovered_count = $('#board').find('.uncovered').length;
        if (uncovered_count <= 1) {
            $(this).parent().addClass('uncovered').attr('id', 'word-' + (uncovered_count + 1));
        }

        if (uncovered_count == 1) {
            test();
        }
        return false;
    });

    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $('.card').randomize();

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('#counter_box').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.popup').hide();
                clearInterval(first_counter);
            }
        }
        return false;
    });

    $(window).resize(function(){
        resize();
    })
});