$(function () {
    var Game = {
        stage: 1,
        animationDuration: 10,
        delay: 3,
        clickedGood: 0,
        itemsOnStage: 0,
        correctItemsOnStage: 0,
        currentItem: 0,
        currentStageItem: 0,
        init: function () {
            $('.flying-item').randomize();
            $('.flying-item').on('click', function () {
                Game.choosen($(this));
            }).css('visibility', 'visible').hide();
            $('#stage2, #stage3').css('visibility', 'visible').hide();
        },
        animateItem: function ($item) {
            var left = Math.floor((Math.random() * ($('#stage' + Game.stage).width() - 250)));
            $item.css('left', left + 'px');
            if ($item.data('element-id') == 1) {
                Game.correctItemsOnStage++;
            }
            Game.currentStageItem++;
            $item.show();
            $item.animate({
                bottom: $(document).height() + "px"
            }, Game.animationDuration * 1000, "linear", function () {
                var item_stage_id = $item.data('stage-id');
                var parent_id = $item.parent().attr('id');
                $item.remove();
                if (item_stage_id == 6 && Game.stage <= 3
                && parent_id == 'stage' + Game.stage) {
                    $('#wrong_info').show();
                    $('#stage-popup').show();
                    $('#stage-popup').find('.stage-info').addClass('end-popup-error');
                }
            });

        },
        startStage: function () {
            var items = $('#stage' + Game.stage).find('div.flying-item');
            Game.itemsOnStage = items.length;

            items.each(function (i, element) {
                $(element).css('left', '400px').css('bottom', '0');
                $(element).data('stage-id', (i + 1));
                setTimeout(function () {
                    Game.currentItem++;
                    Game.animateItem($(element));
                }, Game.delay * 1000 * i);
            });


        },
        choosen: function ($element) {
            if ($element.data('element-id') == 1) {
                $element.addClass('good');
                Game.stage++;
                Game.itemsOnStage = 0;
                $('#stage' + (Game.stage - 1)).hide()
                if (Game.stage <= 3) {
                    setTimeout(function () {
                        $('#stage' + Game.stage).show();
                        Game.startStage();
                    }, 500);
                } else {
                    $('#success_info').show();
                    $('#stage-popup').show();
                }
            } else {
                $element.addClass('wrong');
                setTimeout(function () {
                    $element.hide();
                }, 500);
            }
        }
    };

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('#counter_box').html('<span id="counter">3</span>');

        $('.refresh').on('click', function () {
            location.reload();
            return false;
        });

        $.fn.randomize = function (a) {
            (a ? this.find(a) : this)
                .parent().each(function () {
                    $(this)
                        .children(a).sort(function () {
                            return Math.random() - 0.5
                        })
                        .detach().appendTo(this)
                });
            return this
        };


        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('#startgame-popup').hide();
                Game.init();
                Game.startStage();
                clearInterval(first_counter);
            }
        }

        return false;
    });

});