var class_draggable = '.sentence';
var class_droppable = '.sentence-place';



$stage = 1;

function nextStage() {
    $('.start-popup').hide();
    $stage++;
    $('.stage').hide();
    if ($stage < 3) {
        $('#stage-' + $stage).show();
    } else {
        $('.end-popup').show();
    }

}

function testOrder() {
    if ($stage == 1) {
        var all_ok = true;
        $('.sentence').each(function () {
            if ($(this).parent().data('element-id') != $(this).data('element-id')) {
                all_ok = false;
            }
        });
        if (all_ok) {
            $('#check').show();
        }
    } else {
        var all_have_text = true;
        $('input').each(function () {
            if ($(this).val() == ' ' || $(this).val() == '') {
                all_have_text = false;
            }
        });

        if (all_have_text) {
            $('#check-2').show();
        }
    }
}

function checkAnswers(){
    var all_good = true;
    $('input').each(function () {
       if($(this).data('element-id') != $(this).val()){
           all_good = false;
       }
    });

    return all_good;
}


$(function () {

    $('input').on('keyup', function(){
        testOrder();
    }).val('').prop('disabled', false);

    $('.refresh.inner').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
            $(this).data('originalParent', $(this).parent());
        },
        revert: function (dropped) {
            if ($(dropped).data('element-id') != $(this).data('element-id')) {
                return true;
            }
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.data('dropped', true);


                var prev_element = $(this).children(class_draggable);

                if (prev_element.length > 0 &&
                    prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                    return true;
                }

                $(ui.draggable).detach().css({
                    top: 0,
                    left: 0
                }).appendTo(this);
                $(this).addClass('haselement');


                prev_element.each(function () {
                    $(this).appendTo($(this).data('originalParent')).removeClass('notapproved');
                });


                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
            }
            testOrder();
        }
    });

    $('.draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this;
    };
    $(class_draggable).randomize();

    $('#check').on('click', function () {
        $('#next-stage-popup').show();
        return false;
    }).hide();

    $('body').delegate('#next-stage', 'click', function () {
        nextStage();
        return false;
    }).delegate('#check-2', 'click', function () {
        if(checkAnswers()){
            $('#good').show();
        }else{
            $('#wrong').show();
        }
        return false;
    }).delegate('.showanswers', 'click', function () {
        $('.end-popup').hide();
        $('.answer').show();
        $('input').prop('disabled', true);
        $('#check-2').hide();
        $('.pound').hide();
        return false;
    }).delegate('.pound', 'click', function () {
        var input = $(this).siblings('input');
        input.val(input.val() + String.fromCharCode(163));
        return false;
    });

    $('.stage').hide();
    $('#stage-1').show();

    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 100);
        $('#first-popup .start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('#first-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });


});

