var class_draggable = '.caption';
var class_droppable = '.tale-caption';

var current_color = 1;

function testOrder() {
    var allok = true;
    $(class_droppable).each(function () {
        if ($(this).find(class_draggable).length == 1 && $(this).data('element-id') != $(this).find(class_draggable).data('element-id')){
            allok = false;
        }
    });

    if (allok && $(class_droppable).find(class_draggable + '.approved').length == 12) {
        setTimeout(function () {
            $('.end-popup').show();
        }, 500);
    }
}

function testClicked(){
    var count = 0;
    $('#wrpr > span').each(function () {
       if($(this).hasClass('green-bg') ||  $(this).hasClass('yellow-bg')){
           count++;
       }
    });
    if(count == 12){
        $('.end-popup-0').show();
    }
}

function checkPair($element){

    var is_correct = 1;
    var pair_color = '';
    if($element.hasClass('green-bg')){
        pair_color = 'yellow-bg';
    }else{
        pair_color = 'green-bg';
    }

    if($element.parents('td').siblings('td').find('.caption').length > 0){
        var pair = $element.parents('td').siblings('td').find('.caption');
        if(!pair.hasClass(pair_color) || pair.data('element-name') != $element.data('element-name')){
            is_correct = -1;
        }else{
            pair.addClass('approved').removeClass('notapproved')
                .draggable({disabled: true})
                .parent().droppable('disable');
        }
    }else{
        is_correct = 0;
    }

    return is_correct;
}

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });

    $('#wrpr > span').on('click', function () {
        if ($(this).hasClass('person') && current_color == 1) {
            $(this).addClass('green-bg');
        } else {
            if ($(this).hasClass('item') && current_color == 2) {
                $(this).addClass('yellow-bg');
            } else {
                $(this).addClass('wrong-bg');
                setTimeout(function () {
                    $('#wrpr > span').removeClass('wrong-bg');
                }, 1000)
            }
        }

        testClicked();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);


            var prev_element = $(this).children(class_draggable);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            prev_element.each(function () {
                $(this).appendTo('#draggables').removeClass('notapproved');
            });

            if ($(this).data('element-id') === ui.draggable.data('element-id')){
                if(checkPair($(ui.draggable)) == 1){
                    ui.draggable.draggable({disabled: true});
                    $(this).droppable('disable');
                    ui.draggable.removeClass('notapproved').addClass('approved');
                }

                if(checkPair($(ui.draggable)) == -1){
                    ui.draggable.addClass('notapproved');
                }

                if(checkPair($(ui.draggable)) == 0){
                    ui.draggable.removeClass('notapproved');
                }
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();

        }
    });

    $('#draggables').droppable({
        accept: class_draggable,
        tolerance: "pointer",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();
    $('#wrpr > span').randomize();

    $('#button-box').find('a').on('click', function () {
        $('#button-box').find('a').removeClass('focus');
        $(this).addClass('focus');
        if ($(this).attr('id') == 'green') {
            current_color = 1;
        } else {
            current_color = 2;
        }
        return false;
    });

    $('body').delegate('#next', 'click', function () {
        $('#stage-1').hide();
        $('#stage-2').show();
        $('.end-popup-0').hide();
        return false;
    });


    $('#start-game').on('click', function () {

        $('.end-popup-0').css('visibility', 'visible').hide();

        var first_count = 3;
        var first_counter = setInterval(countdown, 100);
        $('#counter_box').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });

});

