var class_draggable = '.sentence';
var class_droppable = '.sentence-place';

$stage = 1;

function nextStage() {
    $('.start-popup').hide();
    $stage++;
    $('.stage').hide();
    if ($stage < 3) {
        $('#stage-' + $stage).show();
        $('#next-stage-popup').show();

    } else {
        $('.end-popup').show();
    }

}

function testOrder() {
    var all_ok = true;
    $('#stage-' + $stage).find('.sentence').each(function () {
        if (!$(this).parent().hasClass('sentence-place')) {
            all_ok = false;
        }
    });
    if (all_ok) {
        if ($stage == 1) {
            $('#check-1').show();
        } else {
            $('#check-2').show();
        }
    }
}

$(function () {

    $('#jquery_jplayer_1').jPlayer({
        swfPath: '/',
        solution: 'html, flash',
        supplied: 'mp3',
        preload: 'metadata',
        volume: 0.8,
        muted: false,
        backgroundColor: '#000000',
        errorAlerts: true,
        warningAlerts: false,
        cssSelectorAncestor: '#jp_container_1',
        ready: function (event) {
            $(this).jPlayer("setMedia", {
                title: "",
                mp3: "audio/034.mp3"
            });
        }
    });

    $('#jquery_jplayer_2').jPlayer({
        swfPath: '/',
        solution: 'html, flash',
        supplied: 'mp3',
        preload: 'metadata',
        volume: 0.8,
        muted: false,
        backgroundColor: '#000000',
        errorAlerts: true,
        warningAlerts: false,
        cssSelectorAncestor: '#jp_container_2',
        ready: function (event) {
            $(this).jPlayer("setMedia", {
                title: "",
                mp3: "audio/035.mp3"
            });
        }
    });


    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
            $(this).data('originalParent', $(this).parent());
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);

            var prev_element = $(this).children(class_draggable);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            testOrder();
        }
    });

    $('.draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

        }
    });

    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this;
    };

    $(class_draggable).randomize();

    $('body').delegate('#check-1', 'click', function () {
        $(this).hide();
        $('#jquery_jplayer_1').show();
        $('#jp_container_1').show();
        $('#next-1').show();
        $('#stage-1 .sentence').draggable({disabled: true});
        $('#stage-1 .sentence-place').droppable('disable');
        return false;
    }).delegate('#next-1', 'click', function () {
        nextStage();
        return false;
    }).delegate('#next-stage', 'click', function () {
        $('#next-stage-popup').hide();
        return false;
    }).delegate('#check-2', 'click', function () {
        $(this).hide();
        $('#jquery_jplayer_2').show();
        $('#jp_container_2').show();
        $('#next-2').show();
        $('#stage-2 .sentence').draggable({disabled: true});
        $('#stage-2 .sentence-place').droppable('disable');
        return false;
    }).delegate('#next-2', 'click', function () {
        $('#good').show();
        return false;
    });

    $('.stage').hide();
    $('#stage-1').show();


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 100);
        $('#first-popup .start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('#first-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });


});

