;
(function ($, window, document, undefined) {
    $.fn.randomize = function (selector) {
        (selector ? this.find(selector) : this).parent().each(function () {
            $(this).children(selector).sort(function () {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function (game, opts) {
        var _this = this,
            findWord = function findWord(word) {
                var result;

                $.each(_this.opts.words, function (i, obj) {
                    if (obj.word === word) {
                        result = obj;
                        return false;
                    }
                });

                return result;
            };

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function () {
            this.renderElements();
            this.renderSentence();

            this.$element.find(".popup-instruction, .popup-overlay").show();
        };


        this.checkIfEmptyFields = function () {
            $('.sentence-element-container').each(function(){
                var words_inside = $(this).find('.word-container').find('.element');
                if(words_inside.length == 0){
                    $(this).removeClass('has-element');
                }
            });
        };

        this.renderSentence = function () {
            var html = this.opts.sentence.replace(/({[a-zA-Z ]+})/g, function (match) {
                var word = match.replace(/[}{]+/g, ""),
                    storedWord = findWord(word),
                    $span = $("<div><div class='sentence-element-container'><div class='image-container'><img /></div><div class='word-container'></div></div></div>")
                        .find("img").attr("src", storedWord.img).end()
                        .find(".word-container").attr("data-word", word).end();

                return $span.html();
            });

            this.$element.find(".sentence-container").html(html);

            this.$element.find(".sentence-element-container").droppable({
                accept: ".element",
                drop: function (e, ui) {
                    if ($(this).find(".word-container").data('word') != ui.draggable.data('word')) {
                        ui.draggable.data('dropped', false);
                        ui.draggable.addClass('result-incorrect');
                        setTimeout(function(){
                            ui.draggable.removeClass('result-incorrect');
                        }, 1000);
                        $(this).removeClass("active-drop");
                        return false;
                    }else{
                        ui.draggable.draggable({disabled: true});
                    }

                    $(this).removeClass("active-drop");

                    if($(this).hasClass('has-element')){
                        return false;
                    }
                    var $draggable = $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).appendTo($(this).addClass("has-element").find(".word-container"));
                    setTimeout(function () {
                        _this.resize();
                        _this.check();
                    }, 100);
                    $(this).droppable('disable');
                    _this.checkIfEmptyFields();
                },
                over: function () {
                    $(this).addClass("active-drop");
                },
                out: function () {
                    $(this).removeClass("active-drop");
                }
            }).each(function () {
               // $(this).width(_this.$element.find(".element[data-word='" + $(this).find(".word-container").attr("data-word") + "']").outerWidth());
            });

            this.$element.find(".elements-container").droppable({
                drop: function (e, ui) {
                    $(this).removeClass("active-drop");

                    $(ui.draggable).detach().appendTo($(this));
                    setTimeout(function () {
                        _this.resize();
                        _this.check();
                    }, 100);
                    _this.checkIfEmptyFields();
                },
                over: function () {
                    $(this).addClass("active-drop");
                },
                out: function () {
                    $(this).removeClass("active-drop");
                }
            })
        };

        this.renderElements = function () {
            var $element = $("<div/>").addClass("element");

            $.each(this.opts.words, function (i, word) {
                var $el = $element.clone()
                    .text(word.word)
                    .attr("data-word", word.word)
                    .appendTo(_this.$element.find(".elements-container"));
            });

            this.$element.find(".element").randomize();

            this.$element.find(".element").draggable({
                start: function (event, ui) {
                    ui.helper.data('dropped', false);
                    $(this).css('z-index', '10');
                },
                revert: function (dropped) {
                    var dropped = dropped && dropped[0].id == "droppable";

                    if (!dropped) {
                        $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                        $(this).appendTo($(this).data('originalParent'));
                        // $(this).css('width', 'auto');
                        $(this).css('z-index', '2');
                    }

                    return !dropped;
                }
            });
        };

        this.delegateEvents = function () {
            this.$element.find("#refresh").on("click", function () {
                window.location.reload();
                return false;
            });

            this.$element.find(".start").on("click", function () {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });

            $(window).on("resize", function () {
                _this.resize();
            }).trigger("resize");
        };

        this.check = function () {
            this.$element.find(".sentence-element-container .element").each(function () {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect");
                if ($this.closest(".word-container").attr("data-word") === $this.attr("data-word")) {
                    $this.addClass("result-correct");
                }
                else {
                    $this.addClass("result-incorrect");
                }
            });
            if (this.$element.find(".sentence-element-container .element.result-correct").size() === this.$element.find(".element").size()) {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function () {
           // this.$element.find(".sentence-container").css("line-height", ((this.$element.find(".sentence-container").height() - 50) / 4) + "px");
            //this.$element.find(".elements-container").css("line-height", (this.$element.find(".elements-container").height()) + "px");
            //this.$element.find(".sentence-element-container").height(((this.$element.find(".sentence-container").height() - 50) / 4) + "px");
        };
    };

    var Game = function (opts) {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function () {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);