$(function () {
    var Game = {
        correctStages: 0,
        stage: 1,
        animationDuration: 20,
        delay: 3,
        clickedGood: 0,
        itemsOnStage: 0,
        correctItemsOnStage: 0,
        currentItem: 0,
        currentStageItem: 0,
        init: function () {
            $('#end-score').hide();
            $('.flying-item').randomize();
            $('.flying-item').on('click', function () {
                Game.choosen($(this));
                return false;
            }).css('visibility', 'visible').hide();
            $('.stage').css('visibility', 'visible').hide();
            $('#stage1').show();
            $('body').delegate('a#next-stage', 'click', function () {
                $('#stage-popup').hide();
                $('#stage' + (Game.stage - 1)).hide();
                $('#stage' + Game.stage).show();
                Game.startStage();
                return false;
            });
        },
        animateItem: function ($item) {
            var top = Math.floor((Math.random() * ($('#stage' + Game.stage).height()- 200 )));
            $item.css('top', top + 'px').css('left', $(document).width() + 'px');
            if ($item.data('element-id') == 1) {
                Game.correctItemsOnStage++;
            }

            Game.currentStageItem++;
            $item.show();
            $item.animate({
                left: -$(document).width() + "px"
            }, Game.animationDuration * 1000, "linear", function () {
                var item_stage_id = $item.data('stage-id');
                if ( item_stage_id == Game.itemsOnStage && $item.data('stage') == Game.stage) {
                    $('#stage' + Game.stage).find('div.flying-item').each(function () {
                        if($(this).data('element-id') == 0){
                            $(this).trigger('click');
                            return false;
                        }
                    });
                }
                $item.remove();
            });

        },
        startStage: function () {
            var items = $('#stage' + Game.stage).find('div.flying-item');
            Game.itemsOnStage = items.length;

            items.each(function (i, element) {
                $(element).data('stage-id', (i + 1));
                $(element).data('stage', Game.stage);
                setTimeout(function () {
                    Game.currentItem++;
                    Game.animateItem($(element));
                }, Game.delay * 1000 * i);
            });


        },
        choosen: function ($element) {
            if ($element.data('element-id') == 1) {
                $element.addClass('good');
                Game.correctStages++;
                $('#success_info').show();
                $('#wrong_info').hide();
                $('#stage-popup').removeClass('error');
            } else {
                $('#success_info').hide();
                $('#wrong_info').show();
                $('#stage-popup').addClass('error');
                $element.addClass('wrong');
            }
            Game.nextStage();
            if (Game.stage > 4) {
                if(Game.correctStages == 4){
                    $('#stage-popup').removeClass('error');
                    $('#end-score').html('Brawo, poprawnie wykonane zadanie.');
                }else{
                    $('#stage-popup').addClass('error');
                    $('#end-score').html('Niestety, nie wszystkie odpowiedzi były poprawne.');
                }
                $('#success_info').hide();
                $('#wrong_info').hide();
                $('#end-score').show();
            }

            $('#stage-popup').show();
        },
        nextStage: function () {
            Game.stage++;
            Game.clickedGood = 0;
            Game.correctItemsOnStage = 0;
            Game.itemsOnStage = 0;
            Game.currentStageItem = 0;

            if (Game.stage > 4) {
                $('#next-stage').hide();
                $('.refresh.outer').show();
            }
        }
    };
    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };

    Game.init();

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 100);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();

                Game.startStage();
                clearInterval(first_counter);
            }
        }

        return false;

    });

});