$(function () {
    var Game = {
        correctStages: 0,
        stage: 1,
        animationDuration: 10,
        delay: 3,
        clickedGood: 0,
        itemsOnStage: 0,
        correctItemsOnStage: 0,
        currentItem: 0,
        currentStageItem: 0,
        lastCorrect: false,
        init: function () {
            $('#end-score').hide();
            $('.flying-item').randomize();
            $('.flying-item').on('click', function () {
                Game.choosen($(this));
                return false;
            }).css('visibility', 'visible').hide();
            $('.stage').css('visibility', 'visible').hide();
            $('#stage1').show();
            $('body').delegate('a#next-stage', 'click', function () {
                $('#stage-popup').hide();
                $('#stage' + (Game.stage - 1)).hide();
                $('#stage' + Game.stage).show();
                Game.startStage();
                return false;
            });
        },
        animateItem: function ($item) {
            var left = Math.floor((Math.random() * ($('#stage' + Game.stage).width() - 250)));
            $item.css('left', left + 'px');
            if ($item.data('element-id') == 1) {
                Game.correctItemsOnStage++;
            }

            Game.currentStageItem++;
            $item.show();
            $item.animate({
                top: $(document).height() + "px"
            }, Game.animationDuration * 1000, "linear", function () {
                var item_stage_id = $item.data('stage-id');
                if ( item_stage_id == Game.itemsOnStage && $item.data('stage') == Game.stage) {
                    $('#stage' + Game.stage).find('div.flying-item').each(function () {
                        if($(this).data('element-id') == 0){
                            $(this).trigger('click');
                            return false;
                        }
                    });
                }
                $item.remove();
            });

        },
        startStage: function () {
            var items = $('#stage' + Game.stage).find('div.flying-item');
            Game.itemsOnStage = items.length;

            items.each(function (i, element) {
                $(element).data('stage-id', (i + 1));
                $(element).data('stage', Game.stage);
                setTimeout(function () {
                    Game.currentItem++;
                    Game.animateItem($(element));
                }, Game.delay * 1000 * i);
            });


        },
        choosen: function ($element) {
            if ($element.data('element-id') == 1) {
                $element.addClass('good');
                Game.correctStages++;
                $('#success_info').show();
                $('#wrong_info').hide();
                $('#stage-popup').removeClass('error');
                Game.lastCorrect = true;
            } else {
                $('#success_info').hide();
                $('#wrong_info').show();
                $('#stage-popup').addClass('error');
                $element.addClass('wrong');
                Game.lastCorrect = false;
            }
            Game.nextStage();
            if (Game.stage > 5) {

                if(Game.lastCorrect){
                    var lastScore = 'Ostatnie zadanie - poprawne.</br>';
                }else{
                    var lastScore = 'Ostatnie zadanie - niepoprawne.</br>';
                }

                if(Game.correctStages == 5){
                    $('#stage-popup').removeClass('error');
                    $('#end-score').html(lastScore + 'Brawo, poprawnie wykonane zadanie.');
                }else{
                    $('#stage-popup').addClass('error');
                    $('#end-score').html(lastScore + 'Niestety, nie wszystkie odpowiedzi były poprawne.');
                }
                $('#success_info').hide();
                $('#wrong_info').hide();
                $('#end-score').show();
            }

            $('#stage-popup').show();
        },
        nextStage: function () {
            Game.stage++;
            Game.clickedGood = 0;
            Game.correctItemsOnStage = 0;
            Game.itemsOnStage = 0;
            Game.currentStageItem = 0;

            if (Game.stage > 5) {
                $('#next-stage').hide();
                $('.refresh.outer').show();
            }
        }
    };
    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };

    Game.init();

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 10);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();

                Game.startStage();
                clearInterval(first_counter);
            }
        }

        return false;

    });

});