var class_draggable = '.trash';
var class_droppable = '.trash-cntnr';

var class_draggable_2 = '.caption';
var class_droppable_2 = '.frame';

function testOrder() {
    var trash_left = $('#draggables').find('div').length;

    var inputs_ok = true;
    $('input').each(function () {
       if($(this).val() == ' ' || $(this).val() == '' || $(this).hasClass('notapproved')){
           inputs_ok = false;
       }
    });

    if(trash_left == 0 && inputs_ok && $('#frames-box').find('div.approved').length == 4){
        setTimeout(function () {
              $('.end-popup').show();
        }, 1000);
    }
}


$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_draggable_2).draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable_2.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if ($(this).parent().hasClass(class_droppable_2.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            if ($(this).data('element-id') !== ui.draggable.data('element-id')) {
                ui.draggable.data('dropped', false);
                return false;
            }
            ui.draggable.data('dropped', true);

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.draggable({disabled: true});
                ui.draggable.removeClass('notapproved').addClass('approved').fadeOut('slow');
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();
        }
    });

    $(class_droppable_2).droppable({
        accept: class_draggable_2,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);


            var prev_element = $(this).children(class_draggable_2);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            prev_element.each(function () {
                $(this).appendTo('#caption-box').removeClass('notapproved');
            });

            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();
        }
    });

    $('#draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });

    $('#caption-box').droppable({
        accept: class_draggable_2,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });

    $('input').on('keyup', function () {
       if($(this).val() == $(this).data('element-number')){
           $(this).addClass('approved').removeClass('notapproved');
       }else{
           $(this).addClass('notapproved').removeClass('approved');
       }
        testOrder();
    }).val('');


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();
    $(class_draggable_2).randomize();


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });


});

