;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            screen1: {
                elements: [
                    {
                        img: "img/places/morze.png",
                        correctValue: "sea"
                    },
                    {
                        img: "img/places/gory.png",
                        correctValue: "mountains"
                    },
                    {
                        img: "img/places/jeziora.png",
                        correctValue: "lake"
                    },
                    {
                        img: "img/places/plaza.png",
                        correctValue: "beach"
                    },
                    {
                        img: "img/places/las.png",
                        correctValue: "forest"
                    }
                ]
            },
            screen2: {
                elements: [
                    {
                        img: "img/places/morze.png",
                        correctValue: "sea"
                    },
                    {
                        img: "img/places/gory.png",
                        correctValue: "mountains"
                    },
                    {
                        img: "img/places/jeziora.png",
                        correctValue: "lake"
                    },
                    {
                        img: "img/places/plaza.png",
                        correctValue: "beach"
                    },
                    {
                        img: "img/places/las.png",
                        correctValue: "forest"
                    }
                ]
            },
            screen3: {
                elements: [
                    {
                        img: "img/places/morze.png",
                        correctValue: "I can see sea.",
                        secondCorrectValue: "I can see sea"
                    },
                    {
                        img: "img/places/gory.png",
                        correctValue: "I can see mountains.",
                        secondCorrectValue: "I can see mountains"
                    },
                    {
                        img: "img/places/jeziora.png",
                        correctValue: "I can see lake.",
                        secondCorrectValue: "I can see lake"
                    },
                    {
                        img: "img/places/plaza.png",
                        correctValue: "I can see beach.",
                        secondCorrectValue: "I can see beach"
                    },
                    {
                        img: "img/places/las.png",
                        correctValue: "I can see forest.",
                        secondCorrectValue: "I can see forest"
                    }
                ]
            }
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            // screen 1
            var $element1 = $("<div class='element'><div class='has-photo'><img alt='' /></div><div class='has-input'><input type='text' /></div></div>"),
                $screen1 = this.$element.find("#screen-1");

            $.each(this.settings.screen1.elements, function(key, obj)
            {
                var $el = $element1.clone().appendTo($screen1.find(".wrapper"));
                $el.find("img").attr("src", obj.img);
                $el.find("input").attr("data-correct-value", obj.correctValue);
            });

            this.activeScreen = 1;

            this.$element.find("#screen-1 input").on("blur", function()
            {
                var $this = $(this),
                    value = $.trim($this.val() ? $this.val().toLowerCase() : "");

                $this.removeClass("result-correct").removeClass("result-incorrect");

                if(value)
                {
                    if(value.toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.addClass("result-correct");
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                }

                _this.checkScreen1();
            }).on("keyup", function()
            {
                var $this = $(this),
                    value = $this.val() || "";

                if(value)
                {
                    if(value.toLowerCase() === $this.attr("data-correct-value"))
                    {
                        $this.removeClass("result-incorrect").addClass("result-correct");
                        _this.checkScreen1();
                    }
                    else
                    {
                        $this.removeClass("result-correct");
                    }
                }
            });

            this.$element.find("#popup-1 .next").on("click", function()
            {
                _this.$element.find(".screen, .popup, .popup-overlay").hide();
                _this.$element.find("#screen-2").show();
                $(window).trigger("resize");
                $("body,html").scrollTop(0);
                return false;
            });

            this.$element.find("#screen-1 .element").randomize();

            // screen 2
            var $screen2 = this.$element.find("#screen-2"),
                $element2 = $("<div><img alt='' /></div>").addClass("element"),
                $value = $("<div><p></p></div>").addClass("value"),
                elements2Count = 1;

            $.each(this.settings.screen2.elements, function(key, obj)
            {
                var $el = $element2.clone().find("img").attr("src", obj.img).end().appendTo(_this.$element.find("#screen-2 .elements"));
                $el.attr("data-correct-value", obj.correctValue);
                $el.attr("id", "element-" + elements2Count);

                var $val = $value.clone().find("p").text(obj.correctValue).end().appendTo(_this.$element.find("#screen-2 .values"));
                $val.attr("data-correct-value", obj.correctValue);
                $val.attr("id", "value-" + elements2Count);

                elements2Count += 1;
            });
            //this.$element.find(".values .value").randomize();

            this.$element.find("#popup-2 .next").on("click", function()
            {
                _this.$element.find(".screen, .popup, .popup-overlay").hide();
                _this.$element.find("#screen-3").show();
                $("body,html").scrollTop(0);
                return false;
            });

            this.initJSPlumb();

            this.$element.find("#screen-2 .value").randomize();
            this.$element.find("#screen-2 .element").randomize();

            var $screen3 = this.$element.find("#screen-3");
            $.each(this.settings.screen3.elements, function(key, obj)
            {
                var $el = $element1.clone().appendTo($screen3.find(".wrapper"));
                $el.find("img").attr("src", obj.img);
                $el.find("input").attr("data-correct-value", obj.correctValue).attr("data-correct-secondvalue", obj.secondCorrectValue);
            });

            this.$element.find("#screen-3 input").on("blur", function()
            {
                var $this = $(this),
                    value = $.trim($this.val() ? $this.val().toLowerCase() : "");

                $this.removeClass("result-correct").removeClass("result-incorrect");

                if($this.val())
                {
                    if(value === $this.attr("data-correct-value").toLowerCase() || value === $this.attr("data-correct-secondvalue").toLowerCase())
                    {
                        $this.addClass("result-correct");
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                }

                _this.checkScreen3();
            });

            this.$element.find("#screen-3 .element").randomize();

            this.$element.find("#screen-2, #screen-3").hide();

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".element").on("click", function()
            {
                $(this).find("input").trigger("focus");
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.val())
                        {
                            if($input.val().toLowerCase() === $input.attr("data-correct-value").toLowerCase())
                            {
                                return $input.closest(".element").next(".element").find("input");
                            }
                        }
                    }
                }
            });
            this.$element.on("screenKeyboard.on", function()
            {
                $('.screen').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('.screen').removeClass("screen-keyboard-on");
            });

        },
        initJSPlumb: function()
        {
            var _this = this;

            this.connections = [];

            var instance = jsPlumb.getInstance({
                DragOptions: {cursor: 'pointer', zIndex: 2000},
                ConnectionOverlays: [],
                Container: "screen-2"
            });

            var connectorPaintStyle = {
                    lineWidth: 4,
                    strokeStyle: "#058EB5",
                    joinstyle: "round",
                    outlineColor: "white",
                    outlineWidth: 2
                },
                connectorHoverStyle = {
                    lineWidth: 4,
                    strokeStyle: "#216477",
                    outlineWidth: 2,
                    outlineColor: "white"
                },
                endpointHoverStyle = {
                    fillStyle: "#216477",
                    strokeStyle: "#216477"
                },
                sourceEndpoint = {
                    endpoint: "Dot",
                    paintStyle: {
                        strokeStyle: "#FFBA00",
                        fillStyle: "transparent",
                        radius: 35,
                        lineWidth: 3
                    },
                    isSource: true,
                    connector: ["Bezier", {curviness: 250}],
                    connectorStyle: connectorPaintStyle,
                    hoverPaintStyle: endpointHoverStyle,
                    connectorHoverStyle: connectorHoverStyle,
                    dragOptions: {},
                    overlays: []
                },
                targetEndpoint = {
                    endpoint: "Dot",
                    paintStyle: {fillStyle: "#FFBA00", radius: 35},
                    hoverPaintStyle: endpointHoverStyle,
                    maxConnections: -1,
                    dropOptions: {hoverClass: "hover", activeClass: "active"},
                    isTarget: true,
                    overlays: []
                };
            instance.doWhileSuspended(function()
            {
                instance.addEndpoint("element-1", targetEndpoint, {anchor: "LeftMiddle"});
                instance.addEndpoint("element-2", targetEndpoint, {anchor: "LeftMiddle"});
                instance.addEndpoint("element-3", targetEndpoint, {anchor: "LeftMiddle"});
                instance.addEndpoint("element-4", targetEndpoint, {anchor: "LeftMiddle"});
                instance.addEndpoint("element-5", targetEndpoint, {anchor: "LeftMiddle"});

                instance.addEndpoint("value-1", sourceEndpoint, {anchor: "RightMiddle"});
                instance.addEndpoint("value-2", sourceEndpoint, {anchor: "RightMiddle"});
                instance.addEndpoint("value-3", sourceEndpoint, {anchor: "RightMiddle"});
                instance.addEndpoint("value-4", sourceEndpoint, {anchor: "RightMiddle"});
                instance.addEndpoint("value-5", sourceEndpoint, {anchor: "RightMiddle"});

                instance.bind("connection", function(connInfo, originalEvent)
                {
                    var $target = $(connInfo.target),
                        $source = $(connInfo.source);

                    _this.connections.push({
                        id: $source.attr("id") + $target.attr("id"),
                        isValid: $target.attr("data-correct-value") === $source.attr("data-correct-value")
                    });

                    _this.checkScreen2();
                });

                instance.bind('connectionDetached', function(conn, originalEvent)
                {
                    var removekey = -1;
                    $.each(_this.connections, function(i, obj)
                    {
                        if(obj.id == conn.sourceId + conn.targetId){
                            removekey = i;
                        }
                    });
                    if(removekey > -1){
                        _this.connections.splice(removekey, 1);
                    }
                    console.log(_this.connections);
                });

                instance.bind('connectionMoved', function(conn, originalEvent)
                {
                    var removekey = -1;
                    $.each(_this.connections, function(i, obj)
                    {
                        if(obj.id == conn.originalSourceId + conn.originalTargetId){
                            removekey = i;
                        }
                    });
                    if(removekey > -1){
                        _this.connections.splice(removekey, 1);
                    }
                });
            });

            jsPlumb.fire("jsPlumbDemoLoaded", instance);

            $(window).on("resize", function()
            {
                instance.repaintEverything();
            });
        },
        checkScreen1: function()
        {
            var correctCount = 0;
            this.$element.find("#screen-1 input").each(function()
            {
                if ($(this).hasClass("result-correct"))
                {
                    correctCount += 1;
                }
            });

            if (correctCount === this.settings.screen1.elements.length)
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find("#popup-1, .popup-overlay").show();
            }
        },
        checkScreen2: function()
        {
            if (this.connections.length === this.settings.screen2.elements.length)
            {
                var isValid = true;
                $.each(this.connections, function(i, obj)
                {
                    if (!obj.isValid)
                    {
                        isValid = false;
                        return false;
                    }
                });

                if (isValid)
                {
                    this.$element.find("#popup-2, .popup-overlay").show();
                }
            }
        },
        checkScreen3: function()
        {
            var correctCount = 0;
            this.$element.find("#screen-3 input").each(function()
            {
                if($(this).hasClass("result-correct"))
                {
                    correctCount += 1;
                }
            });

            if(correctCount === this.settings.screen1.elements.length)
            {
                this.$element.find("#popup-result, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);