
function checkCrosswords(){
    var all_ok = true;
    $('.crossword-box').each(function () {
       if($(this).find('.correct').length == $(this).find('input').length){
           $(this).find('input').addClass('approved');
       }else{
           all_ok = false;
       }
    });

    if(all_ok){
        setTimeout(function () {
            $('.end-popup').show();
        }, 2000);
    }
}

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
        return false;
    });


    $(":input[type='text']").val('').keyup(function (event) {
        if($(this).val() == $(this).data('element-name') || $(this).val() == $(this).data('element-id')){
            $(this).addClass('correct');
        }

        checkCrosswords();


    });

    $('#game-ex38-s81').screenKeyboard({
        keys: {
            type: "custom",
            keys: ["a", 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
                'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'v',
                'w', 'x', 'y', 'z']
        },
        inputs: {
            selectors: ["input"],
            next: function ($input) {
                var $next = $input.next("input");
                if($next.size())
                {
                    return $next;
                }
                $next = $input.closest(".crossword-box").next(".crossword-box").find("input:first");
                if($next.size())
                {
                    return $next;
                }
                return false;
            }
        }
    }).on("screenKeyboard.on", function () {
        $('#wrapper').addClass("screen-keyboard-on");
    }).on("screenKeyboard.off", function () {
        $('#wrapper').removeClass("screen-keyboard-on");
    });


    $("input").on("keyup", function(e)
    {
        var key = e.keyCode ? e.keyCode : e.charCode,
            $next,
            $prev;

        if (key !== 8 && key !== 46)
        {
            if ($(this).val())
            {
                $next = $(this).next("input");
                $(this).trigger("blur");
                $next.trigger("focus");
            }
        }
        else
        {
            $(this).val("");
            $prev = $(this).prev("input");
            $prev.focus();
        }
    }).on('change', function(){
        if($(this).val().length > 1) {
            $(this).val($(this).val()[0])
        }
    });


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 100);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
        }

        return false;
    });

});

